% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cogmapr.R
\name{plotIndCMap}
\alias{plotIndCMap}
\title{Plotting an Individual Cognitive Map}
\usage{
plotIndCMap(ind.cmap, layoutType = "neato",
  main = paste("Individual map -", ind.cmap[["agent"]][["name"]]), ...)
}
\arguments{
\item{ind.cmap}{An object of class IndCMap, as an output of the IndCMap function}

\item{layoutType}{Type of graph. See detail in RGraphviz. Can be 'neato', 'dot', 'twopi', 'circo', and 'fdp'. The default is 'neato'.}

\item{main}{The title of the map. By default it is "Individual map - Agent's name"}

\item{...}{other graphical parameters}
}
\value{
A plot
}
\description{
Plotting an Individual Cognitive Map
}
\examples{
project_name <- "a_new_project"
main_path <- paste0(system.file("testdata", package = "cogmapr"), '/')
my.project <- ProjectCMap(main_path, project_name)

icm <- IndCMap(my.project, 1)

plotIndCMap(icm)
}
