% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cogmapr-indic.R
\name{ConceptIndicatorsICM}
\alias{ConceptIndicatorsICM}
\title{Concept Indicators of vertices by document (tidy data)}
\usage{
ConceptIndicatorsICM(project, doc_id = "all")
}
\arguments{
\item{project}{A QDA project, a list as generated by the ProjectCMap function.}

\item{doc_id}{"all" (default) or the ID of document to include.}
}
\value{
A data frame (tidy data) with all indicators, their values by document (ICM)
}
\description{
Concept Indicators of vertices by document (tidy data)
}
\details{
Concept Indicators of vertices by document (tidy data)
}
\examples{
project_name <- "a_new_project"
main_path <- paste0(system.file("testdata", package = "cogmapr"), '/')
my.project <- ProjectCMap(main_path, project_name)

ConceptIndicatorsICM(my.project)
ConceptIndicatorsICM(my.project, 2)
}
