% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cmsaf.time.series.R
\name{cmsaf.time.series}
\alias{cmsaf.time.series}
\title{Plotting routine designed for the CM SAF R Toolbox.}
\usage{
cmsaf.time.series(
  var1,
  infile1,
  var2,
  infile2,
  outfile1,
  outfile2,
  plot.out = FALSE,
  nc34 = 4,
  overwrite = FALSE,
  verbose = FALSE,
  toolbox = FALSE,
  nc1 = NULL,
  nc2 = NULL
)
}
\arguments{
\item{var1}{Name of the first NetCDF variable (character).}

\item{infile1}{Filename of the first input NetCDF file. This may include the directory
(character).}

\item{var2}{Name of the second NetCDF variable (character).}

\item{infile2}{Filename of the second input NetCDF file. This may include the directory
(character).}

\item{outfile1}{Filename of the first output NetCDF file. This may include the directory
(character).}

\item{outfile2}{Filename of the second output NetCDF file. This may include the directory
(character).}

\item{plot.out}{logical; if TRUE, the plot will be stored in the same folder as outfile1.
If FALSE, the plot will not be saved.}

\item{nc34}{NetCDF version of output file. If \code{nc34 = 3} the output file will be
in NetCDFv3 format (numeric). Default output is NetCDFv4.}

\item{overwrite}{logical; should existing output file be overwritten?}

\item{verbose}{logical; if TRUE, progress messages are shown}

\item{toolbox}{logical; if TRUE, toolbox mode enabled. The two files are adjusted in space
and time so that they can be plotted.}

\item{nc1}{Alternatively to \code{infile1} you can specify the input as an
object of class \code{ncdf4} (as returned from \code{ncdf4::nc_open}).}

\item{nc2}{Alternatively to \code{infile2} you can specify the input as an
object of class \code{ncdf4} (as returned from \code{ncdf4::nc_open}).}
}
\value{
Two NetCDF files are written.
}
\description{
This function renders a time series plot of two variables.
}
\seealso{
Other 1d visualization: 
\code{\link{cmsaf.hist}()},
\code{\link{cmsaf.hovmoller}()},
\code{\link{cmsaf.scatter}()}
}
\concept{1d visualization}
