% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cpa.normal.R
\name{cpa.normal}
\alias{cpa.normal}
\title{Analytic power calculations for parallel arm cluster-randomized trials with normal outcomes}
\usage{
cpa.normal(
  alpha = 0.05,
  power = NA,
  nclusters = NA,
  nsubjects = NA,
  sigma_sq = NA,
  sigma_b_sq = NA,
  CV = 0,
  d = NA,
  ICC = NA,
  vart = NA,
  method = c("taylor", "weighted"),
  tol = .Machine$double.eps^0.25
)
}
\arguments{
\item{alpha}{The level of significance of the test, the probability of a
Type I error.}

\item{power}{The power of the test, 1 minus the probability of a Type II
error. Defaults to NA.}

\item{nclusters}{The number of clusters per condition. It must be greater than 1.}

\item{nsubjects}{The mean of the cluster sizes, or a vector of cluster sizes for one arm.
When nsubjects is a vector, CV and nclusters are calculated from nsubjects and 
user-entered CV and nclusters is ignored.}

\item{sigma_sq}{Within-cluster (residual) variance, \mjseqn{\sigma^2}.}

\item{sigma_b_sq}{Between-cluster variance \mjseqn{\sigma^2_b}.}

\item{CV}{The coefficient of variation of the cluster sizes. When \code{CV} = 0,
the clusters all have the same size.}

\item{d}{The difference in condition means.}

\item{ICC}{The intraclass correlation \mjseqn{\sigma_b^2 / (\sigma_b^2 + \sigma^2)}.
Accepts a numeric between 0-1.}

\item{vart}{The total variation of the outcome (the sum of within- and 
between-cluster variation) \mjseqn{\sigma_b^2 + \sigma^2}.}

\item{method}{The method for calculating variance inflation due to unequal cluster
sizes. Either a method based on Taylor approximation of relative efficiency
("taylor"), or weighting by cluster size ("weighted"). Default is \code{"taylor"}.}

\item{tol}{Numerical tolerance used in root finding. The default provides
at least four significant digits.}
}
\value{
The computed value of the NA parameter (from among \code{alpha}, \code{power}, \code{nclusters}, \code{nsubjects},
  \code{CV}, and \code{d}) needed to satisfy the power and 
sample size equation.
}
\description{
\loadmathjax

Compute the power, number of clusters needed, number of subjects per cluster 
needed, or other key parameters for a simple parallel cluster randomized 
trial with a normal outcome.

Exactly one of \code{alpha}, \code{power}, \code{nclusters}, \code{nsubjects},
  \code{CV}, and \code{d}  must be passed as \code{NA}.
  Note that \code{alpha}, \code{power}, and \code{CV} have non-\code{NA}
  defaults, so if those are the parameters of interest they must be
  explicitly passed as \code{NA}. The user must supply sufficient variance 
  parameters to produce values for both the ICC and the total variance by providing 2 of the 
  following: \code{ICC}, \code{vart}, \code{sigma_b_sq}, or \code{sigma_sq}.

If \code{nsubjects} is a vector, the values \code{nclusters} and \code{CV} will be recalculated
   using the values in \code{nsubjects}. If \code{nsubjects} is a vector and \code{method} is
   "taylor", the exact relative efficiency will be calculated as described in
   van Breukelen et al (2007).
}
\section{Note}{

  This function was inspired by work from Stephane Champely (pwr.t.test) and
  Peter Dalgaard (power.t.test). As with those functions, 'uniroot' is used to
  solve power equation for unknowns, so you may see
  errors from it, notably about inability to bracket the root when
  invalid arguments are given. This generally means that no solution exists for which the 
  omitted parameter and the supplied parameters fulfill the equation.  In particular, the desired
  power may not be achievable with any number of subjects or clusters.
}

\section{Testing details}{

This function has been verified against reference values from the NIH's GRT
Sample Size Calculator, PASS11, \code{CRTsize::n4means}, and
\code{clusterPower::cps.normal}.
}

\section{Authors}{

Jonathan Moyer (\email{jon.moyer@gmail.com}), 
Alexandria C. Sakrejda (\email{acbro0@umass.edu}),
and Ken Kleinman (\email{ken.kleinman@gmail.com})
}

\examples{
# Find the number of clusters per condition needed for a trial with alpha = .05, 
# power = 0.8, 10 observations per cluster, no variation in cluster size, a difference 
# of 1 unit,  ICC = 0.1 and a variance of five units:
\dontrun{
cpa.normal(nsubjects = 10, d = 1, ICC = .1, vart = 5)
 }
# The result, showing nclusters of greater than 15, suggests 16 clusters per 
# condition should be used.

# Find the power achieved with 16 clusters, 10 subjects per cluster,
# difference between condition of 1 unit, ICC = .1, and total variance
# of 5 units:
\dontrun{
cpa.normal(power = NA, nclusters = 16, nsubjects = 10, d = 1,
           sigma_b_sq = .5, vart = 5)
}
# The result shows the power is 0.801766.

# Find the power achieved when each trial arm has 5 clusters of
# sizes 100, 50, 25, 100, and 100. When a vector of cluster sizes 
# is provided (as in this example), the "ncluster" argument is ignored.

\dontrun{
cpa.normal(alpha = .05, power = NA, nsubjects = c(100, 50, 25, 100, 100),
           d = .2, ICC = .1, sigma_b_sq = .1)
}
# The result shows the power is 0.13315.

# Find the power achieved with 20 clusters per arm, where
# the cluster sizes vary but have a mean size of 100 and coefficient of variation of .5:
\dontrun{
cpa.normal(alpha = .05, power = NA, nclusters = 20, nsubjects = 100, CV = .5,
           d = .2, ICC = .1, sigma_b_sq = .1)
}
# The result shows the power is 0.4559881.

}
\references{
Eldridge SM, Ukoumunne OC, Carlin JB. (2009) The Intra-Cluster Correlation
  Coefficient in Cluster Randomized Trials: A Review of Definitions. Int Stat Rev.
  77: 378-394.

Eldridge SM, Ashby D, Kerry S. (2006) Sample size for cluster randomized
  trials: effect of coefficient of variation of cluster size and analysis method.
  Int J Epidemiol. 35(5):1292-300.

van Breukelen GJP, Candel MJJM, Berger MPF. (2007) Relative efficiency of
  unequal versus equal cluster sizes in cluster randomized and multicentre trials.
  Statist Med. 26:2589-2603.
}
