% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inputDataMaker.R
\name{inputDataMaker}
\alias{inputDataMaker}
\title{Creating suitable inputData for clustering of the dose-response curve patterns}
\usage{
inputDataMaker(dose, response, ID, inputDataset)
}
\arguments{
\item{dose}{either a single string or a scalar, indicating the name of the dose column or its index.}

\item{response}{either a single string or a scalar, indicating the name of the response column or its index.}

\item{ID}{either a single string or a scalar, indicating the name of the ID column or its index.}

\item{inputDataset}{a data frame containing the input dataset, it should at least include dose, response, and ID}
}
\value{
a list with the following elements:

inputDataset: includes the ID (first column), and the response for all doses with their replications for each subject as rows.
doseLevels: unique dose levels
numReplicatrions: number of replicatios per each unique dose level.
colsData: the index of columns with responses.
colID: the index of ID column.
}
\description{
function to create needed information as the input of the functions to cluster 
dose-response cruve patterns.
}
\details{
Note that the output of this function can be feed into the function for clustering dose-response curve patterns.
}
\examples{
 
## gnerating data
set.seed(11)
doses2Use <-  c(0, 5, 20)
numRep2Use <- c(3, 3, 3)
generatedData <- cbind(rep(1,sum(numRep2Use)), 
MCPMod::genDFdata("logistic",c(5, 3, 10, 0.05), 
doses2Use, numRep2Use, 1), 
		matrix(rnorm(1*sum(numRep2Use)), sum(numRep2Use), 1))
colnames(generatedData) <- c("ID", "dose", "response", "x1")
for (iGen in 2:15){
	genData0 <- cbind(rep(iGen,sum(numRep2Use)), 
MCPMod::genDFdata("logistic",c(5, 3, 10, 0.05), 
doses2Use, numRep2Use, 1), 
			matrix(rnorm(1*sum(numRep2Use)), sum(numRep2Use), 1))
	colnames(genData0) <- c("ID", "dose", "response", "x1")
	generatedData <- rbind(generatedData, genData0)
}
## transforming it for clustering
toInput <- inputDataMaker(2, 3, 1, generatedData)

}
\author{
Vahid Nassiri, and Yimer Wasihun
}
