% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper.R
\name{clupoints_n_1_template}
\alias{clupoints_n_1_template}
\title{Create points from their projections on a cluster-supporting line}
\usage{
clupoints_n_1_template(projs, lat_disp, clu_dir, dist_fn)
}
\arguments{
\item{projs}{Point projections on the cluster-supporting line
(\mjeqn{p \times n}{p x n} matrix).}

\item{lat_disp}{Dispersion of points from their projection.}

\item{clu_dir}{Direction of the cluster-supporting line (unit vector).}

\item{dist_fn}{Function to place points on a second line, orthogonal to the
first.}
}
\value{
Generated points (\mjeqn{p \times n}{p x n} matrix).
}
\description{
\loadmathjax
Generate points from their \mjseqn{n}-dimensional projections on a
cluster-supporting line, placing each point on a hyperplane orthogonal to
that line and centered at the point's projection. The function specified in
\code{dist_fn} is used to perform the actual placement.
}
\details{
This function is used internally by \link{clupoints_n_1} and may be useful for
constructing user-defined final point placement strategies for the
\code{point_dist_fn} parameter of the main \link{clugen} function.
}
\note{
This function is stochastic. For reproducibility set a PRNG seed with
\link{set.seed}.
}
\examples{
set.seed(123)
ctr <- c(0, 0)
dir <- c(1, 0)
pdist <- c(-0.5, -0.2, 0.1, 0.3)
proj <- points_on_line(ctr, dir, pdist)
clupoints_n_1_template(proj, 0, dir, function(p, l) stats::runif(p))
}
