% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotclmplus.R
\name{plot.clmplusmodel}
\alias{plot.clmplusmodel}
\title{Plot the hazard model fitted and forecasted parameters}
\usage{
\method{plot}{clmplusmodel}(x, cy.type = "fe", ...)
}
\arguments{
\item{x}{clmplus model to be plotted.}

\item{cy.type}{whether to show fitted period effect with or without extrapolatio Default is "fe", standing for fitted and extrapolated. Alternative is to specify "f" for fitted effect.}

\item{...}{Arguments to be passed to plot.}
}
\value{
No return value, plots coefficients of the hazard models.
}
\description{
This function allows to define the behavior of the triangle payments.
}
\examples{
data(sifa.mtpl)
sifa.mtpl.rtt <- RtTriangle(cumulative.payments.triangle=sifa.mtpl)
hz.chl<-clmplus(sifa.mtpl.rtt, 'a')
plot(hz.chl)

}
\references{
Hiabu, Munir. “On the relationship between classical chain ladder and granular reserving.” 
Scandinavian Actuarial Journal 2017 (2017): 708 - 729.
}
