% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots-errorbarClinData.R
\name{errorbarClinData}
\alias{errorbarClinData}
\title{Interactive plot of confidence interval/error interval of clinical data.}
\usage{
errorbarClinData(
  data,
  xVar,
  xLab = getLabelVar(xVar, labelVars = labelVars),
  yVar,
  yLab = getLabelVar(yVar, labelVars = labelVars),
  yErrorVar = NULL,
  yErrorLab = getLabelVar(yErrorVar, labelVars = labelVars),
  xErrorVar = NULL,
  xErrorLab = getLabelVar(xErrorVar, labelVars = labelVars),
  xLabVars = NULL,
  xAxisLab = paste(c(xLab, xErrorLab), collapse = " and "),
  yAxisLab = paste(c(yLab, yErrorLab), collapse = " and "),
  colorVar = NULL,
  colorLab = getLabelVar(colorVar, labelVars = labelVars),
  colorPalette = NULL,
  shapeVar = NULL,
  shapeLab = getLabelVar(shapeVar, labelVars = labelVars),
  shapePalette = NULL,
  size = 6,
  titleExtra = NULL,
  title = paste(c(paste(yAxisLab, "vs", xAxisLab), titleExtra), collapse = "<br>"),
  subtitle = NULL,
  caption = NULL,
  labelVars = NULL,
  mode = "markers",
  legendPosition = "bottom",
  width = NULL,
  height = NULL,
  pathVar = NULL,
  pathLab = getLabelVar(pathVar, labelVars = labelVars),
  hoverVars,
  hoverLab,
  id = paste0("plotClinData", sample.int(n = 1000, size = 1)),
  selectVars = NULL,
  selectLab = getLabelVar(selectVars, labelVars = labelVars),
  table = FALSE,
  tableVars,
  tableLab,
  tableButton = TRUE,
  tablePars = list(),
  verbose = FALSE
)
}
\arguments{
\item{data}{Data.frame with data.}

\item{xVar}{String with column of \code{data} containing x-variable.}

\item{xLab}{String with label for \code{xVar}.}

\item{yVar}{String with column of \code{data} containing y-variable.}

\item{yLab}{String with label for \code{xVar}.}

\item{xErrorVar, yErrorVar}{String with variable of \code{data}
containing the width of the interval (from
the center of the interval) for
horizontal or vertical intervals.}

\item{xErrorLab, yErrorLab}{String with labels
for \code{xErrorVar}/\code{yErrorVar} variables.}

\item{xLabVars}{(vertical error bars) 
Character vector with variable(s) to be displayed 
as the labels of the ticks in the x-axis.\cr
By default, \code{xVar} is displayed.\cr
In case the variable(s) contain different elements 
by \code{xVar}, they are combined
and displayed below each other.}

\item{xAxisLab, yAxisLab}{Label for the x/y-axis.}

\item{colorVar}{(optional) String with color variable.}

\item{colorLab}{String with label for \code{colorVar}.}

\item{colorPalette}{(optional) Named character vector with color palette.
If not specified, the viridis color palette is used.\cr
See \code{\link[clinUtils]{clinColors}}.}

\item{shapeVar}{(optional) String with shape variable.}

\item{shapeLab}{String with label for \code{shapeVar}.}

\item{shapePalette}{(optional) Named character vector with 
shape palette, \code{\link[clinUtils]{clinShapes}}
by default.}

\item{size}{Integer with size of markers in pixels, 
6 by default.}

\item{titleExtra}{String with extra title for the plot (appended after \code{title}).}

\item{title}{String with title for the plot.}

\item{subtitle}{String with subtitle.\cr
The subtitle is included at the top left of the plot,
below the title.}

\item{caption}{String with caption. \cr
The caption is included at the bottom right of the plot.
Please note that this might overlap with 
vertical or rotated x-axis labels.}

\item{labelVars}{Named character vector containing variable labels.}

\item{mode}{String with the mode of the plot,
'markers' by default, so only data points are displayed. \cr
This can also be set to 'lines' to include a line connecting
the center of the error bars instead; or 'lines+markers' 
to include both a marker and a line.\cr
See \code{mode} attribute for plotly scatter.}

\item{legendPosition}{String with position of the legend,
among: 'top'/'left'/'bottom'/'right', 'bottom' by default.}

\item{width}{Numeric, width of the plot in pixels,
700 by default.}

\item{height}{Numeric, height of the plot in pixels,
700 by default.}

\item{pathVar}{String with variable of \code{data} containing hyperlinks 
with path to the subject-specific report, formatted as: \cr
\preformatted{<a href="./path-to-report">label</a>}.\cr 
If multiple, they should be separated by: ', '.\cr
The report(s) will be:
\itemize{
\item{compressed to a zip file and downloaded 
if the user clicks on the 'p' (a.k.a 'profile') key
when hovering on a point of the plot}
\item{included in a collapsible row, and clickable with hyperlinks
in the table}
}}

\item{pathLab}{String with label for \code{pathVar},
included in the collapsible row in the table.}

\item{hoverVars}{Character vector with variable(s) to be displayed in the hover,
by default any position and aesthetic variables displayed in the plot.}

\item{hoverLab}{Named character vector with labels for \code{hoverVars}.}

\item{id}{String with general id for the plot:
\itemize{
\item{'id' is used as \code{group} for the \code{\link[crosstalk]{SharedData}}}
\item{'button:[id]' is used as button ID if \code{table} is TRUE}
}
If not specified, a random id, as 'plotClinData[X]' is used.}

\item{selectVars}{(optional) Character vector with variable(s) from \code{data}
for which a selection box should be included. This enables to select the data
displayed in the plot (and associated table).}

\item{selectLab}{(Named) character vector with label for \code{selectVars}.}

\item{table}{Logical, if TRUE (FALSE by default)
returns also a \code{datatable} containing the plot data.
(The plot and the table are not linked.)}

\item{tableVars}{Character vector with variables to be included 
in the table.}

\item{tableLab}{Named character vector with labels
for each \code{tableVars}.}

\item{tableButton}{Logical, if TRUE (by default)
the table is included within an HTML button.}

\item{tablePars}{List with parameters passed to the
\code{\link[clinUtils]{getClinDT}} function.}

\item{verbose}{Logical, if TRUE (FALSE by default) progress messages are printed
in the current console.
For the visualizations, progress messages during download
of subject-specific report are displayed in the browser console.}
}
\value{
Either:
\itemize{
\item{if a \code{table} is requested: }{
a \code{clinDataReview} object, a.k.a a list with the 
'plot' (\code{\link[plotly]{plotly}} object) and 'table'
(\code{\link[DT]{datatable}} object)}
\item{otherwise: }{a \code{\link[plotly]{plotly}} object}
}
}
\description{
This plot is designed to display summary statistics
of a continuous variable with (confidence) intervals.\cr
The intervals are either displayed:
\itemize{
\item{vertically if \code{yErrorVar} is specified}
\item{horizontally if \code{xErrorVar} is specified}
}
Error bars can visualized by group, via the color variable parameter.\cr
Different symbols are set for each central point of the error bar
via the shape variable parameter.
}
\examples{
library(clinUtils)

data(dataADaMCDISCP01)
labelVars <- attr(dataADaMCDISCP01, "labelVars")

## Summary plot with vertical error bars

dataVSDIABP <- subset(dataADaMCDISCP01$ADVS, 
	PARAMCD == "DIABP" & ANL01FL == "Y" &
	AVISIT \%in\% c("Baseline", "Week 2", "Week 4", "Week 6", "Week 8")
)

# compute summary statistics by visit
if (requireNamespace("inTextSummaryTable", quietly = TRUE)) {
	
summaryTableVSDIABP <- inTextSummaryTable::computeSummaryStatisticsTable(
	data = dataVSDIABP,
	rowVar = c("AVISIT", "ATPT"),
	var = "AVAL",
	stats = inTextSummaryTable::getStats(c("n", "Mean", "SE")),
	labelVars = labelVars
)
dataPlot <- subset(summaryTableVSDIABP, !isTotal)

errorbarClinData(
	data = dataPlot,
	xVar = "AVISIT",
	colorVar = "ATPT",
	# use non-rounded statistics for the plot
	yVar = "statMean", yErrorVar = "statSE", 
	yLab = "Mean", yErrorLab = "Standard Error",
	# include lines connecting the error bars
	mode = "markers+lines",
	labelVars = labelVars
)

# add number of subjects in labels
dataPlot$nSubj <- with(dataPlot, paste0("N=", n))
errorbarClinData(
	data = dataPlot,
	xVar = "AVISIT", 
	xLabVars = c("AVISIT", "nSubj"),
	colorVar = "ATPT",
	yVar = "statMean", yLab = "Mean",
	yErrorVar = "statSE", yErrorLab = "Standard error",
	mode = "markers+lines",
	title = paste("Diastolic Blood Pressure summary profile by actual visit",
		"and analysis timepoint"),
	labelVars = labelVars
)

## Add a selection box
if(interactive()){
  summaryTable <- inTextSummaryTable::computeSummaryStatisticsTable(
    data = subset(dataADaMCDISCP01$ADVS, 
      ANL01FL == "Y" &
      AVISIT \%in\% c("Baseline", "Week 2", "Week 4", "Week 6", "Week 8")
    ),
    rowVar = c("PARAM", "AVISIT", "ATPT"),
    var = "AVAL",
    stats = inTextSummaryTable::getStats(c("Mean", "SE")),
    labelVars = labelVars
  )
  dataPlot <- subset(summaryTable, !isTotal)
  errorbarClinData(
    data = dataPlot,
    xVar = "AVISIT", 
    colorVar = "ATPT",
    yVar = "statMean", yLab = "Mean",
    yErrorVar = "statSE", yErrorLab = "Standard error",
    mode = "markers+lines",
    title = paste("Lab parameters summary profile by actual visit",
      "and analysis timepoint"),
    labelVars = labelVars,
    selectVars = "PARAM"
  )
}

## Summary plot with horizontal error bars

# Data of interest: ratio from baseline at week 16
dataLBW8 <- subset(dataADaMCDISCP01$ADLBC, grepl("Week 8", AVISIT))
# compute ratio from baseline
dataLBW8$R2BASE <- with(dataLBW8, AVAL/BASE) 
dataLBW8 <- subset(dataLBW8, !is.na(R2BASE))
# Order actual treatments
dataLBW8$TRTA <- with(dataLBW8, reorder(TRTA, TRTAN))

# compute summary statistics of the ratio per baseline per parameter
summaryTableLBW8 <- inTextSummaryTable::computeSummaryStatisticsTable(
	data = dataLBW8,
	var = "R2BASE",
	rowVar = "PARAM",
	colVar = "TRTA",
	stats = inTextSummaryTable::getStats(x = dataLBW8$R2BASE, type = c("n", "Median", "SD"))
)
dataPlot <- subset(summaryTableLBW8, !isTotal)
# extract direction of ratio
dataPlot$dir <- factor(
	ifelse(dataPlot$statMedian >= 1, "Increase", "Decrease"),
	levels = c("Decrease", "Increase")
)
# compute relative ratio (percentage above 1)
dataPlot$statMedianRelative <- with(dataPlot,
	ifelse(statMedian < 1, 1/statMedian, statMedian)
)
# order based on mean relative ratio across treatment arms
params <- names(sort(with(dataPlot, tapply(statMedianRelative, PARAM, mean))))
dataPlot$PARAM <- factor(dataPlot$PARAM, levels = params)
errorbarClinData(
	data = dataPlot,
	xVar = "statMedianRelative", xErrorVar = "statSD",
	xLab = "Median", xErrorLab = "Standard deviation",
	xAxisLab = "Relative ratio from baseline (Median +- SD)",
	yVar = "PARAM",
	colorVar = "TRTA",
	shapeVar = "dir", shapeLab = "Direction of ratio",
	shapePalette = c(`Decrease` = 25, `Increase` = 24),
	size = 10,
	labelVars = labelVars,
	title = "Summary ratio from baseline at week 8 by treatment"
)

}

}
\seealso{
Other visualizations of summary statistics for clinical data: 
\code{\link{barplotClinData}()},
\code{\link{boxplotClinData}()},
\code{\link{plotCountClinData}()},
\code{\link{sunburstClinData}()},
\code{\link{treemapClinData}()}
}
\author{
Laure Cougnaud
}
\concept{visualizations of summary statistics for clinical data}
