% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots-utility-axes.R
\name{getAxisLimPlot}
\alias{getAxisLimPlot}
\title{Get axis limits for a \code{\link[ggplot2]{ggplot}} plot
from the input dataset.}
\usage{
getAxisLimPlot(
  data,
  xVar,
  yVar,
  xLim = NULL,
  yLim = NULL,
  facetPars = NULL,
  refLineData = NULL
)
}
\arguments{
\item{data}{Data.frame with data.}

\item{xVar}{String with column of \code{data} containing x-variable.}

\item{yVar}{String with column of \code{data} containing y-variable.}

\item{xLim}{Numeric vector of length 2 with limits for the x/y axes.}

\item{yLim}{Numeric vector of length 2 with limits for the x/y axes.}

\item{facetPars}{List with facetting parameters, 
passed to the facetting function. Variables should be specified
as character or formula.
For 'wrap' facetting (\code{facetType} is 'wrap'), if the layout
is not specified via \code{nrow}/\code{ncol}, 2 columns
are used by default.}

\item{refLineData}{Data used for the reference lines, as
output of the \code{\link{getDataReferenceLines}} function.}
}
\value{
Data.frame with limits of the:
\itemize{
\item{x-axis: }{'xmin'/'xmax'}
\item{y-axis: }{'ymin'/'ymax'}
}
for each element of the facetting variable (if any).
}
\description{
Get axis limits for a \code{\link[ggplot2]{ggplot}} plot
from the input dataset.
}
