% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reporting-render_clinDataReviewReport.R
\name{getParamsFromConfig}
\alias{getParamsFromConfig}
\title{Get parameters from a config file}
\usage{
getParamsFromConfig(
  configFile,
  configDir = file.path(inputDir, "config"),
  inputDir = "."
)
}
\arguments{
\item{configFile}{String with filename of the config
file of interest in YAML format.}

\item{configDir}{String with directory with config files,
by default a 'config' folder in \code{inputDir}.\cr
It should contain a general 'config.yml' file and dedicated
'config-[X].yml' for each chapter.
The order of each chapter is specified in the 'config' slot in the general 
general 'config.yml'.}

\item{inputDir}{String with input directory,
working directory by default.}
}
\value{
List with parameters from the specified \code{configFile}
and the general config file: \code{config.yml}.\cr
There are two specific handlers:
\itemize{
\item{parameters tagged with '[param] !r [value]'
are evaluated in R, and their evaluated value is returned}
\item{parameters tagged with '[param] !r-lazy [value]'
are imported as character, and need to be further process
with \code{\link{forceParams}} inside the report.}
}
Parameters with YAML type 'r-lazy' are imported as character,
with this additional class.
}
\description{
Please note that the information from this config file
and the general config file: \code{config.yml}
are considered.\cr
In case parameters are defined both in the general
and specific config files, the parameter from the
general config file is ignored.
}
\seealso{
\link{forceParams}

Other clinical data reporting: 
\code{\link{checkReportTitles}()},
\code{\link{convertMdToHtml}()},
\code{\link{forceParams}()},
\code{\link{getMdHeader}()},
\code{\link{gitbook_clinDataReview_report}()},
\code{\link{html_clinDataReview_report}()},
\code{\link{knitPrintClinDataReview}()},
\code{\link{render_clinDataReviewReport}()}
}
\author{
Laure Cougnaud
}
\concept{clinical data reporting}
