% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/na_replace.R
\name{na_replace}
\alias{na_replace}
\alias{na_replace.default}
\alias{na_replace.data.frame}
\alias{na_replace.matrix}
\alias{na_replace.list}
\alias{na_replace.numeric}
\alias{na_replace.Date}
\alias{na_replace.logical}
\title{Replace NA values}
\usage{
na_replace(x, ...)

\method{na_replace}{default}(x, replacement = "", ...)

\method{na_replace}{data.frame}(x, ..., replacement = NULL)

\method{na_replace}{matrix}(x, replacement = 0, ...)

\method{na_replace}{list}(x, replacement = NULL, ...)

\method{na_replace}{numeric}(x, replacement = 0, ...)

\method{na_replace}{Date}(x, replacement = Sys.Date(), ...)

\method{na_replace}{logical}(x, replacement = FALSE, ...)
}
\arguments{
\item{x}{any vector, data.frame, matrix or list with values of which \code{NA} must be replaced}

\item{...}{When \code{x} is a \code{data.frame}: columns of \code{x} to affect. This supports tidy evaluation without the need to quote the columns, see Examples.}

\item{replacement}{value to replace \code{NA} with. This is at default: \code{0} for numeric values and class \link{matrix}, \code{FALSE} for class \link{logical}, today for class \code{Date}, and \code{""} otherwise. Can also be a vector with the length of the number of NAs of \code{x} (\code{sum(is.na(x))}). When \code{x} is a \code{data.frame}, this can be a vector with the length of the number of columns to be affected, see Examples.}
}
\description{
This is a generic function to replace NA values in data. It takes most data types as input and is extendible by other packages.
}
\details{
All functions preserve attributes. Within a \code{list} or \code{data.frame}, all attributes per index/item/column are also preserved.
}
\examples{
mtrx <- matrix(c(1, 2, NA, 3), nrow = 2)
mtrx
na_replace(mtrx)

na_replace(c(1, 2, NA, NA))
na_replace(c(1, 2, NA, NA), replacement = -1)
na_replace(c(1, 2, NA, NA), replacement = c(0, -1))

na_replace(c(Sys.Date(), NA)) # replacement defaults to 'today'

na_replace(c(TRUE, FALSE, NA))
na_replace(c(TRUE, FALSE, NA), replacement = TRUE)

# we're flexible, the class only remains the same if
# the replacement value allows it
na_replace(c(1, 2, 3, NA), replacement = "-")

# data.frame is a special case
mtcars[1:6, c("mpg", "hp")] <- NA
head(mtcars)
head(na_replace(mtcars, mpg, hp)) # no need to quote columns (but you can)
head(na_replace(mtcars, mpg, hp, replacement = c(999, 123)))

\dontrun{
# practical way using tidyverse
library(dplyr)
starwars \%>\% 
  na_replace()

# even maintains groups
starwars \%>\%
  group_by(hair_color) \%>\%
  na_replace(hair_color, replacement = "TEST!") \%>\% 
  summarise(n = n())
}
}
