% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/insert_citation.R
\name{insert_citation}
\alias{insert_citation}
\title{Invoke RStudio add-in to insert Markdown citations}
\usage{
insert_citation(bib_file = getOption("citr.bibliography_path"),
  use_betterbiblatex = getOption("citr.use_betterbiblatex"),
  betterbiblatex_format = getOption("citr.betterbiblatex_format"),
  encoding = getOption("citr.encoding"))
}
\arguments{
\item{bib_file}{Character. Path to Bib(La)TeX-file. See details.}

\item{use_betterbiblatex}{Logical. If \code{use_betterbiblatex = TRUE} references are imported from Zotero/Juris-M.}

\item{betterbiblatex_format}{Charcter. Bibliography format to export from Zotero/Juris-M. Can be either \code{"bibtex"} or \code{"biblatex"}. Ignored if \code{use_betterbiblatex = FALSE}.
Requires that the \href{https://github.com/retorquere/zotero-better-bibtex}{Better Bib(La)TeX} is installed and
Zotero/Juris-M is running.}

\item{encoding}{Character. Encoding of the Bib(La)TeX-file.}
}
\value{
Inserts selected Markdown citation(s) at currenct location.
}
\description{
Invoke RStudio add-in to insert Markdown citations
}
\details{
The path to the Bib(La)TeX-file can be set in the global options and is set to
   \code{./references.bib} when the package is loaded. Once the path is changed in the
   RStudio addin, the global option is updated. If \code{use_betterbiblatex = TRUE} references
   are imported from Zotero/Juris-M rather than from the Bib(La)TeX-file. The Bib(La)TeX-file
   is then updated to include the inserted reference.

   If \code{insert_citation} is called while the focus is on a R Markdown document,
   which includes a YAML front matter with paths to one or more bibliography files,
   \code{bib_file} is ignored. Instead the file(s) from the YAML front matter are used.

   The addin caches bibliographies to avoid unnecessary hard drive access. If
   the specified bibliography path or the file paths in the YAML header change the files
   are reloaded. To manually reload a bibliography at an unchanged location click the
   action link.
}
\examples{
\dontrun{
 insert_citation()
}

}
