% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/md_cite.R
\name{md_cite}
\alias{md_cite}
\title{Insert citation in Markdown format}
\usage{
md_cite(x, in_paren = TRUE, bib_file = options("citr.bibliography_path"),
  cache = TRUE)
}
\arguments{
\item{x}{Character. Search terms used to filter bibliography (by author, year, title, and journal
fields); Regex is supported.}

\item{in_paren}{Logical. Determines if citation is in parentheses.}

\item{bib_file}{Character. Path to Bib(La)TeX-file. See details.}

\item{cache}{Logical. Cached bibliography is used, if available. If \code{cache = FALSE} bibliography
is re-imported on every function call.}
}
\value{
If the bibliography contains exactly one match the formated citation is returned, otherwise
   returns \code{NULL}. \code{md_cite} returns an in-text citation (\code{"@foo2016"}), \code{md_cite}
   returns an in-parenthesis citation (\code{"[@foo2016]"}).
}
\description{
Look up entries in bibliography and insert citation in Markdown format if exactly one match is returned.
}
\details{
The path to the Bib(La)TeX-file can be set in the global options and is set to
   \code{references.bib} when the package is loaded. Once the path is changed in the
   RStudio addin, the global option is updated.
}
\examples{
\dontrun{
  md_cite("foo 2016", bib_file = "references.bib")
}

}
\seealso{
\code{\link{insert_citation}}
}

