library(circlize)
par(mar = c(1, 1, 1, 1))
factors = letters[1:4]
circos.par(points.overflow.warning = FALSE)
circos.initialize(factors = factors, xlim = c(0, 10))
circos.trackPlotRegion(factors = factors, ylim = c(0, 10), track.height = 0.5, panel.fun = function(x, y) {
    circos.text(3, 9, "default", direction = "default")
    circos.text(7, 9, "default2", direction = "default2")
    circos.text(0, 5, "vertical_left", direction = "vertical_left", adj = c(0.5, 0))
    circos.text(10, 5, "vertical_right", direction = "vertical_right", adj = c(0.5, 0))
    circos.text(5, 5, "horizontal", direction = "horizontal")
    circos.text(5, 1, "arc_arc_arc_arc_arc", direction = "arc")
})
circos.clear()
