% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SpatialStack-sp.R, R/SpatialArray-sp.R
\name{spTransform,SpatialStack,ANY-method}
\alias{spTransform,SpatialStack,ANY-method}
\alias{spTransform,SpatialArray,ANY-method}
\title{Function to transform the coordinate reference system of an entire SpatialStack or SpatialArray}
\usage{
\S4method{spTransform}{SpatialStack,ANY}(x, CRSobj, ...)

\S4method{spTransform}{SpatialArray,ANY}(x, CRSobj, ...)
}
\arguments{
\item{x}{The \code{\link{SpatialStack}} or \code{\link{SpatialArray}} object.}

\item{CRSobj}{A \code{\link[sp]{CRS}} class or \code{character} object defining a coordinate reference system.}

\item{...}{Additional arguments.}
}
\value{
A \code{\link{SpatialStack}} or \code{\link{SpatialArray}} object.
}
\description{
Joint reprojection of entire sets of vector data.
}
\details{
The function requires the rgdal package to run.
}
\examples{
# load example data
data(coasts)
mollCoast <- spTransform(coasts, "+proj=moll")
}
