% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classes.R
\docType{class}
\name{RasterArray-class}
\alias{RasterArray-class}
\alias{RasterArray}
\title{Virtual Array of RasterLayers}
\arguments{
\item{stack}{A \code{RasterStack} class object.}

\item{index}{A \code{vector}, \code{matrix} or \code{array} type object. Includes either the indices of layers in the stack, or their names.}

\item{dim}{A \code{numeric} vector. Same as for \code{array}, creates \code{proxy} procedurally.}
}
\value{
A \code{RasterArray} class object.
}
\description{
Array template for RasterLayers
}
\details{
The class implements structures to organize RasterLayers that have the same dimensions. Subsetting rules were defined using the proxy object in the \code{index} slot. See examples for implementations.

The class has two slots:
stack: RasterStack, the actual data.
index: A proxy object that represents the organization of the layers.
}
\examples{
# data import
  data(dems)
  st <-dems@stack
  ind <- 1:nlayers(st)
  names(ind) <- letters[1:length(ind)]
  ra<- RasterArray(stack=st, index=ind)
  
}
