#' PaleoDEM rasters from the reconstructions Chris Scotese.
#'
#' A dataset containing the paleoDEM reconstructions of Chris Scotese for the time interval 0 - 45 Ma. 
#'
#' @format A \code{\link[chronosphere:RasterArray-class]{RasterArray}} with 10 layers.
#' @usage data(dems)
#' @source 
#' Scotese, C. R. Wright, N. (2018). PALEOMAP Paleodigital Elevation Models (PaleoDEMS) for the Phanerozoic. URL: \url{https://www.earthbyte.org/paleodem-resource-scotese-and-wright-2018/}
"dems"

#' Annual mean temperature and precipitation (2001-2010) 
#'
#' This data set provides annual temperature (bio01, unit: °C) and precipitation (bio12, unit: mm/year) obtained from the CHELSA model (Climatologies at high resolution for the Earth 
#' land surface areas,  v1.2) resampled to 2x2 degrees resolution. CHELSA (\url{http://chelsa-climate.org/}) is a high resolution (30 arc sec, ~1 km) climate data set for the earth land surface areas. 
#' CHELSA_v1 is based on a quasi-mechanistical statistical downscaling of the ERA interim global circulation model. The provided data is in a All products of CHELSA are 
#' in a geographic coordinate system referenced to the WGS 84 horizontal datum. 
#' \cr
#' \cr More details on the technical specification of CHELSA can be found at http://chelsa-climate.org/wp-admin/download-page/CHELSA_tech_specification.pdf.
#' @format A \code{\link[chronosphere:RasterArray-class]{RasterArray}} with 20 layers, 10 rows and two columns.
#' @usage data(clim)
#' @source
#' Karger, D.N., Conrad, O., Böhner, J., Kawohl, T., Kreft, H., Soria-Auza, R.W., Zimmermann, N.E., Linder, H.P. & Kessler, M. (2017) Climatologies at high resolution for the earth’s land surface areas. Scientific Data 4, 170122.
#' \cr
#' \cr Karger, D.N., Conrad, O., Böhner, J., Kawohl, T., Kreft, H., Soria-Auza, R.W., Zimmermann, N.E., Linder, H.P., Kessler, M. (2017) Data from: Climatologies at high resolution for the earth’s land surface areas. Dryad Digital Repository. https://doi.org/10.5061/dryad.kd1d4
"clim"

