% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colours.R
\name{ramps}
\alias{ramps}
\alias{gradinv}
\alias{ocean}
\alias{terra}
\alias{coldhot}
\alias{drywet}
\alias{wet}
\alias{showPal}
\title{Colour gradient ramps for default plotting}
\usage{
gradinv(n)

ocean(n)

terra(n)

coldhot(n)

drywet(n)

wet(n)

showPal(pal = "all", n = 11)
}
\arguments{
\item{n}{Number of different colors to generate from the palette}

\item{pal}{A palette name from the lists below}
}
\value{
A function producing a colour gradient ramp.
}
\description{
The object contains functions produced by the \code{colorRampPalette} function.
}
\details{
\code{show.pal} is used to display the available palettes. You can use \code{pal = "all"} or \code{pal=""} if you want to look at all the available palettes. 
You can also view single palettes individually. The following colour palettes are implemented:
\itemize{
\item \code{gradinv()}: inverse heatmap.
\item \code{ocean()}: ocean bathymetrical colours.
\item \code{terra()}: terrestrial topographical colours.
\item \code{coldhot()}: gradient from blue to red.
\item \code{drywet()}: gradient from brown to green.
\item \code{wet()}: gradient from white to green to blue. 
}
}
