% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_spectrum.R
\name{scan_chrom}
\alias{scan_chrom}
\title{Scan spectrum}
\usage{
scan_chrom(
  chrom_list,
  lambda,
  chr,
  peak_table = NULL,
  scale_spectrum = FALSE,
  spectrum_labels = TRUE,
  export_spectrum = FALSE,
  ...
)
}
\arguments{
\item{chrom_list}{A list of chromatograms in matrix form (timepoints x
wavelengths).}

\item{lambda}{The wavelength to plot the trace at.}

\item{chr}{Numerical index of chromatogram you wish to plot.}

\item{peak_table}{The peak table (output from \code{\link{get_peaktable}}
function).}

\item{scale_spectrum}{Logical. If TRUE, scales spectrum to unit height.
Defaults to FALSE.}

\item{spectrum_labels}{Logical. If TRUE, plots labels on maxima in spectral
plot. Defaults to TRUE.}

\item{export_spectrum}{Logical. If TRUE, exports spectrum to console.
Defaults to FALSE.}

\item{...}{Additional arguments.}
}
\value{
If \code{export_spectrum} is TRUE, returns the spectrum as a \code{
data.frame} with wavelengths as rows and a single column encoding the
absorbance (or normalized absorbance, if \code{scale_spectrum} is TRUE)
at each wavelength. Otherwise, there is no return value.
}
\description{
Convenience function to call plot_spectrum with what = "click".
}
\section{Side effects}{

Plots a chromatographic trace from the specified chromatogram (\code{chr}),
at the specified wavelength (\code{lambda}) with a dotted red line to indicate
the user-selected retention time. The trace is a single column from the
chromatographic matrix.

If \code{plot_spectrum} is TRUE, plots the spectrum for the specified
chromatogram at the user-specified retention time. The spectrum is a single
}

\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
data(Sa_pr)
scan_chrom(Sa_pr, lambda="210", chr=2, export_spectrum=TRUE)
\dontshow{\}) # examplesIf}
}
\author{
Ethan Bass
}
