% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hypothesis_test.r
\name{PerfCurveTest}
\alias{PerfCurveTest}
\title{Perform a hypothesis test for the difference between two performance curves.}
\usage{
PerfCurveTest(
  S1,
  S2,
  X,
  r,
  metric = "rec",
  method = "EmProc",
  type = "pointwise",
  plus = T,
  pool = F,
  alpha = 0.05,
  h = NULL,
  seed = 111,
  mc.rep = 1e+05
)
}
\arguments{
\item{S1}{a vector of scores for scoring algorithm 1.}

\item{S2}{a vector of scores for scoring algorithm 2.}

\item{X}{a vector of activities.}

\item{r}{a vector of testing fractions.}

\item{metric}{the performance curve to use. Options are recall ("rec") and precision ("prec").}

\item{method}{the method to use. Recall options are 
c("EmProc", "binomial", "JZ ind", "mcnemar", "binomial ind"). Precision options are
c("EmProc", "binomial", "JZ ind", "stouffer", "binomial ind").}

\item{type}{specifies whether a point-wise confidence interval 
("pointwise") or a confidence band ("band") should be constructed.}

\item{plus}{should plus correction be applied to the confidence intervals?}

\item{pool}{use pooling for hypothesis tests? Only relevant to "EmProc".}

\item{alpha}{the significance level.}

\item{h}{the bandwidth for the local regression estimator of Lambda.  If NULL, uses the default 
plugin estimator.}

\item{seed}{the random seed.}

\item{mc.rep}{the number of Monte Carlo replicates to use for the sup-t method.}
}
\description{
\code{PerfCurveTest} takes score vectors for two scoring algorithms and an activity vector.
A performance curve is created for the two scoring algorithms and hypothesis tests are performed
at the selected testing fractions.
}
