% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confidence_bands.r
\name{PerfCurveBands}
\alias{PerfCurveBands}
\title{Construct a confidence band for a recall or precision curve}
\usage{
PerfCurveBands(
  S,
  X,
  r,
  metric = "rec",
  type = "band",
  method = "sup-t",
  plus = T,
  conf.level = 0.95,
  boot.rep = 100,
  mc.rep = 1e+05,
  myseed = 111,
  h = NULL
)
}
\arguments{
\item{S}{a vector of scores.}

\item{X}{a vector of activities.}

\item{r}{a vector of testing fractions.}

\item{metric}{the performance curve to use. Options are recall ("rec") and precision ("prec").}

\item{type}{specifies whether a point-wise confidence interval 
("pointwise") or a confidence band ("band") should be constructed.}

\item{method}{the method to use. Point-wise confidence interval options
are "binomial", "JZ", "bootstrap". Confidence band options are "sup-t", "theta-proj".}

\item{plus}{should plus correction be used or not?}

\item{conf.level}{the confidence level for the bands.}

\item{boot.rep}{the number of replicates to use for the bootstrap method.}

\item{mc.rep}{the number of Monte Carlo replicates to use for the sup-t method.}

\item{myseed}{the random seed.}

\item{h}{the bandwidth for the local regression estimator of Lambda.  If NULL, uses the default 
plugin estimator.}
}
\description{
\code{PerfCurveBands} takes a pair of score and activity vectors as input.
A performance curve and confidence band is created for the selected testing fractions.
}
