% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/access_date.R
\name{getAccessDate}
\alias{getAccessDate}
\title{Returns the date the snapshot was last accessed.}
\usage{
getAccessDate(checkpointLocation = "~/")
}
\arguments{
\item{checkpointLocation}{File path where the checkpoint library is stored.  Default is \code{"~/"}, i.e. the user's home directory. A use case for changing this is to create a checkpoint library on a portable drive (e.g. USB drive).}
}
\value{
Named character with last access date
}
\description{
The \code{\link[=checkpoint]{checkpoint()}} function stores a marker in the snapshot folder every time the function gets called. This marker contains the system date, thus indicating the the last time the snapshot was accessed.
}
\seealso{
\code{\link[=checkpointRemove]{checkpointRemove()}}

Other checkpoint functions: 
\code{\link{checkpointArchives}()},
\code{\link{checkpointRemove}()},
\code{\link{checkpoint}()},
\code{\link{getValidSnapshots}()},
\code{\link{mranUrl}()},
\code{\link{setSnapshot}()},
\code{\link{unCheckpoint}()}
}
\concept{checkpoint functions}
