% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checks_df.R
\name{rev_dep_check_tasks_df}
\alias{rev_dep_check_tasks_df}
\title{Build Tasks for Reverse Dependency Checks
Generates checks schedule data.frame appropriate for running reverse
dependency check for certain source package. In such case \code{path} parameter
should point to the source of the development version of the package and
\code{repos} should be a repository for which reverse dependencies should be
identified.}
\usage{
rev_dep_check_tasks_df(
  path,
  repos = getOption("repos"),
  versions = c("dev", "release"),
  ...
)
}
\arguments{
\item{path}{path to the package source. Can be either a single source
code directory or a directory containing multiple package source code
directories.}

\item{repos}{repository used to identify reverse dependencies.}

\item{versions}{character vector indicating against which versions of the
package reverse dependency should be checked. \code{c("dev", "release")}
(default) stands for the classical reverse dependency check. \code{"dev"}
checks only against development version of the package which is applicable
mostly when checking whether adding new package would break tests of
packages already in the repository and take the package as suggests
dependency.}

\item{...}{parameters passed to the task specs allowing to customize
subprocesses.}
}
\value{
The check schedule \code{data.frame} with the following columns:
\itemize{
\item \code{alias}: The alias of the check to run. It also serves the purpose of
providing a unique identifier and node name in the task graph.
\item \code{version}: Version of the package to be checked.
\item \code{package}: Object that inherits from \code{\link[=check_task_spec]{check_task_spec()}}.
Defines how package to be checked can be acquired.
\item \code{custom}:  Object that inherits from \code{\link[=custom_install_task_spec]{custom_install_task_spec()}}.
Defines custom package, for instance only available from local source, that
should be installed before checking the package.
}
}
\description{
Create data.frame which each row defines a package for which R CMD check
should be run. Such data.frame is a prerequisite for generating
\code{\link[=check_design]{check_design()}} which orchestrates all the processes
including dependencies installation.
}
\details{
\verb{_tasks_df()} functions generate check task \code{data.frame} for
all source packages specified by the \code{path}. Therefore it accepts it to be
a vector of an arbitrary length.
}
\seealso{
Other tasks: 
\code{\link{check_task_spec}()},
\code{\link{checked-task-df}},
\code{\link{custom_install_task_spec}()},
\code{\link{install_task_spec}()},
\code{\link{revdep_check_task_spec}()},
\code{\link{source_check_tasks_df}()},
\code{\link{task_spec}()}
}
\concept{tasks}
