% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reporter.R
\name{reporters-internal}
\alias{reporters-internal}
\alias{report_sleep}
\alias{report_sleep.default}
\alias{report_initialize}
\alias{report_status}
\alias{report_finalize}
\title{Reporter Internal Methods}
\usage{
report_sleep(reporter, design, sleep)

\method{report_sleep}{default}(reporter, design, sleep = 1)

report_initialize(reporter, design, envir = parent.frame())

report_status(reporter, design, envir = parent.frame())

report_finalize(reporter, design)
}
\arguments{
\item{reporter}{A object produced using \code{\link{reporters}}. Each reporter is a
thin wrapper around an environment with a class name for dispatch. The
reporter is mutable and captures any necessary state that needs to be
tracked while reporting.}

\item{design}{\code{\link{check_design}} The check design to report as it evaluates.}

\item{sleep}{\code{numeric} An interval to pause between reporter steps.}

\item{envir}{\code{environment} An environment to attach to, to leverage on-exit
hooks.}
}
\description{
Each of the internal methods for reporters take a reporter, the check
design object and a calling environment.
}
\keyword{internal}
