% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cgraph.R
\name{cg.run}
\alias{cg.run}
\title{Evaluate the Graph}
\arguments{
\item{name}{character scalar, name of the node that is evaluated.}

\item{values}{named list or environment, values that are subsituted for the nodes in the graph.}
}
\value{
environment, the value of node \code{name} including the values of all ancestors of \code{name}.
}
\description{
Evaluate node \code{name} in the graph.
}
\details{
\code{$run(name, values = list())}
}
\note{
All nodes required to compute node \code{name} must have a value or their value must be able to be computed at run-time. Nodes can be assigned a value when they are created. Alternatively, argument \code{values} can be used to substitute values for nodes that do not have a value (e.g. inputs) or to fix their values.

Only those nodes needed to compute node \code{name} are evaluated and their values are returned. Values of nodes that have not changed or are not evaluated are not returned.

There is a wrapper function \link[cgraph]{run} that calls this method on the current active graph.
}
\examples{
# Initialize a new computational graph.
x <- cgraph$new()

# Add an input.
a <- x$input(name = "a")

# Square the input (i.e. b = a^2).
b <- cg.pow(a, x$const(2), name = "b")

# Evaluate the graph at a = 2.
values <- x$run(b, list(a = 2))

# Retrieve the value of b.
values$b

}
\author{
Ron Triepels
}
