% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cfbd_coaches.R
\name{cfbd_coaches}
\alias{cfbd_coaches}
\alias{coaches}
\title{\strong{CFBD Coaches Endpoint Overview}}
\usage{
cfbd_coaches(
  first = NULL,
  last = NULL,
  team = NULL,
  year = NULL,
  min_year = NULL,
  max_year = NULL
)
}
\arguments{
\item{first}{(\emph{String} optional): First name for the coach you are trying to look up}

\item{last}{(\emph{String} optional): Last name for the coach you are trying to look up}

\item{team}{(\emph{String} optional): Team - Select a valid team, D1 football}

\item{year}{(\emph{Integer} optional): Year, 4 digit format (\emph{YYYY}).}

\item{min_year}{(\emph{Integer} optional): Minimum Year filter (inclusive), 4 digit format (\emph{YYYY}).}

\item{max_year}{(\emph{Integer} optional): Maximum Year filter (inclusive), 4 digit format (\emph{YYYY})}
}
\value{
\describe{
\item{first_name:character.}{First name of coach.}
\item{last_name:character.}{Last name of coach.}
\item{hire_date:character.}{Hire date of coach.}
\item{school:character.}{School of coach.}
\item{year:integer.}{Season of record.}
\item{games:integer.}{Games as coach.}
\item{wins:integer.}{Wins for the season.}
\item{losses:integer.}{ Losses for the season.}
\item{ties:integer.}{Ties for the season.}
\item{preseason_rank:integer.}{Preseason rank for the school of coach.}
\item{postseason_rank:integer.}{Postseason rank for the school of coach.}
\item{srs:character.}{Simple Rating System adjustment for team.}
\item{sp_overall:character.}{Bill Connelly's SP+ overall for team.}
\item{sp_offense:character.}{Bill Connelly's SP+ offense for team.}
\item{sp_defense:character.}{Bill Connelly's SP+ defense for team.}
}
}
\description{
\strong{Coach information search}
A coach search function which provides coaching records and school history for a given coach\preformatted{cfbd_coaches(first = "Nick", last = "Saban", team = "alabama")
}
}
\examples{
\donttest{
  cfbd_coaches(first = "Nick", last = "Saban", team = "alabama")
}
}
\keyword{Coaches}
