% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/local_conditional_expectations.R
\name{local_conditional_expectations}
\alias{local_conditional_expectations}
\title{Local Conditional Expectation Explainer}
\usage{
local_conditional_expectations(explainer, observations, y = NULL,
  variable_splits = NULL, variables = NULL, grid_points = 101)
}
\arguments{
\item{explainer}{a model to be explained, preprocessed by function `DALEX::explain()`.}

\item{observations}{set of observarvation for which profiles are to be calculated}

\item{y}{true labels for `observations`. If specified then will be added to local conditional expectations plots.}

\item{variable_splits}{named list of splits for variables, in most cases created with `calculate_variable_splits()`. If NULL then it will be calculated based on validation data avaliable in the `explainer`.}

\item{variables}{names of variables for which profiles shall be calculated. Will be passed to `calculate_variable_splits()`. If NULL then all variables from the validation data will be used.}

\item{grid_points}{number of points for profile. Will be passed to `calculate_variable_splits()`.}
}
\value{
An object of the class 'ceteris_paribus_explainer'.
A data frame with calculated LCE profiles.
}
\description{
This explainer works for individual observations.
For each observation it calculates Local Conditional Expectation (LCE) profiles for selected variables.
}
\examples{
library("DALEX")
 \dontrun{
library("randomForest")
set.seed(59)

apartments_rf_model <- randomForest(m2.price ~ construction.year + surface + floor +
      no.rooms + district, data = apartments)

explainer_rf <- explain(apartments_rf_model,
      data = apartments[,2:6], y = apartments$m2.price)

new_apartment <- apartments[1, ]

cp_rf <- ceteris_paribus(explainer_rf, new_apartment)
lce_rf <- local_conditional_expectations(explainer_rf, new_apartment)
lce_rf

lce_rf <- local_conditional_expectations(explainer_rf, new_apartment, y = new_apartment$m2.price)
lce_rf

# Plot LCE
sel_vars <- c("surface", "no.rooms")
plot(lce_rf, selected_variables = sel_vars)

# Compare ceteris paribus profiles with LCE profiles 
plot(cp_rf, selected_variables = sel_vars) + 
   ceteris_paribus_layer(lce_rf, selected_variables = sel_vars, color = "red")

}
}
