% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bugsModel.R
\name{bugsModel}
\alias{bugsModel}
\title{Generating OpenBUGS Model File}
\usage{
bugsModel(formula, fd, sd, random = NULL, modelname = "bugmodel",
  wd = getwd())
}
\arguments{
\item{formula}{A formula object, with the DV on the left of an ~ operator, and predictors on the right. For the part on the right of '~', the specification of submodels can be separated by '|'. So \code{y ~ X1 | X2} means the DV is \code{y},\code{X1} is the term in the mean submodel, and \code{X2} is the term in the dispersion submodel.}

\item{fd}{A string that specifies the parent distribution (see \link{cdfqrFamily}).}

\item{sd}{A string that specifies the sub-family distribution.}

\item{random}{Character or vector of characters that indicates the random effect factors.}

\item{modelname}{The name of the model file; optional.}

\item{wd}{The working directory in which OpenBUGS will work (i.e., generate the model files and chain information).}
}
\value{
A model \sQuote{.txt} file is generated in the specified working directory. The function also returns a list of values:
 \describe{
  \item{init1,init2}{Default initial values for MCMC two chain procedure.}
  \item{vars}{A list of variables that are included in the estimation.}
  \item{nodes_sample}{a list of characters that specify the nodes to be monitored.}
}
}
\description{
Generating OpenBUGS model file
}
\examples{
\dontrun{
# Need write access in the working directory before executing the code.
# No random component
bugsModel(y ~ x1 | x2, 't2','t2', random = NULL)
# Random component as subject ID
bugsModel(y ~ x1 | x2, 't2','t2', random = 'ID')
}

}
