% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/choices.R
\name{cbc_choices}
\alias{cbc_choices}
\title{Simulate choices for a survey design}
\usage{
cbc_choices(design, obsID = "obsID", priors = NULL, n_draws = 100)
}
\arguments{
\item{design}{A data frame of a survey design.}

\item{obsID}{The name of the column in \code{design} that identifies each choice
observation. Defaults to \code{"obsID"}.}

\item{priors}{A list of one or more prior parameters that define a prior
(assumed) utility model used to simulate choices for the \code{survey} data frame.
If \code{NULL} (the default), choices will be randomly assigned.}

\item{n_draws}{The number of Halton draws to use for simulated choices
for mixed logit models. Defaults to \code{100}.}
}
\value{
Returns the \code{design} data frame with an additional \code{choice} column
identifying the simulated choices.
}
\description{
Simulate choices for a survey design, either randomly or according to a
utility model defined by user-provided prior parameters.
}
\examples{
library(cbcTools)

# A simple conjoint experiment about apples

# Generate all possible profiles
profiles <- cbc_profiles(
  price     = c(1, 1.5, 2, 2.5, 3, 3.5, 4, 4.5, 5),
  type      = c("Fuji", "Gala", "Honeycrisp"),
  freshness = c('Poor', 'Average', 'Excellent')
)

# Make a randomized survey design
design <- cbc_design(
  profiles = profiles,
  n_resp   = 300, # Number of respondents
  n_alts   = 3, # Number of alternatives per question
  n_q      = 6 # Number of questions per respondent
)

# Simulate random choices
data <- cbc_choices(
  design = design,
  obsID  = "obsID"
)

# Simulate choices according to a prior utility model
data <- cbc_choices(
  design = design,
  obsID = "obsID",
  priors = list(
    price     = 0.1,
    type      = c(0.1, 0.2),
    freshness = c(0.1, 0.2)
  )
)

# Simulate choices according to a prior model with interactions
data <- cbc_choices(
  design = design,
  obsID = "obsID",
  priors = list(
    price     = 0.1,
    type      = c(0.1, 0.2),
    freshness = c(0.1, 0.2),
    `price*type` = c(0.1, 0.5)
  )
)

# Simulate choices according to a prior utility model with random parameters
data <- cbc_choices(
  design = design,
  obsID = "obsID",
  priors = list(
    price = 0.1,
    type = randN(mean = c(0.1, 0.2), sd = c(1, 2)),
    freshness = c(0.1, 0.2)
  )
)
}
\keyword{logit}
\keyword{logitr}
\keyword{mixed}
\keyword{mnl}
\keyword{mxl}
\keyword{simulation}
