% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/t_mod.R
\name{t_mod}
\alias{t_mod}
\title{A function to estimate conditional expected values and higher order moments}
\usage{
t_mod(treat,
      treat_formula,
      data,
      treat_mod,
      link_function,
      ...)
}
\arguments{
\item{treat}{is the name of the treatment variable contained in \code{data}.}

\item{treat_formula}{an object of class "formula" (or one that can be coerced to that class)
that regresses \code{treat} on a linear combination of \code{X}:
a symbolic description of the model to be fitted.}

\item{data}{is a dataframe containing \code{Y}, \code{treat}, and \code{X}.}

\item{treat_mod}{a description of the error distribution
to be used in the model for treatment. Options include:
\code{"Normal"} for normal model,
\code{"LogNormal"} for lognormal model,
\code{"Poisson"} for Poisson model,
\code{"NegBinom"} for negative binomial model,
\code{"Gamma"} for gamma model.}

\item{link_function}{is either "log", "inverse", or "identity" for the "Gamma" \code{treat_mod}.}

\item{...}{additional arguments to be passed to the low level treatment regression fitting functions.}
}
\value{
\code{t_mod} returns a list containing the following elements:
\item{T_data}{a dataframe containing estimated treatment, estimated treatment squared,
estimated treatment cube, estimated treatment quartic, and estimated gps.}
\item{T_result}{the result of the treatment model fit.}
}
\description{
This function fits a glm regression specified by the user to
estimate conditional moments.
}
\examples{
## Example from Schafer (2015).

example_data <- sim_data

t_mod_list <- t_mod(treat = T,
                    treat_formula = T ~ B.1 + B.2 + B.3 + B.4 + B.5 + B.6 + B.7 + B.8,
                    data = example_data,
                    treat_mod = "Normal")

cond_exp_data <- t_mod_list$T_data

full_data <- cbind(example_data, cond_exp_data)

rm(example_data, t_mod_list, cond_exp_data, full_data)
}
\references{
Schafer, J.L., Galagate, D.L. (2015).  Causal inference with a
continuous treatment and outcome: alternative estimators for parametric
dose-response models. \emph{Manuscript in preparation}.
}
\seealso{
\code{\link{ismw_est}}, \code{\link{reg_est}},
\code{\link{wtrg_est}}, \code{\link{aipwee_est}}, etc. for other estimates.


\code{\link{overlap_fun}} to prepare the \code{data} for use in the different estimates.
}

