% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/densities.R
\name{logDensityTipsCauchy}
\alias{logDensityTipsCauchy}
\title{Log Density of a Cauchy Process}
\usage{
logDensityTipsCauchy(
  tree,
  tipTrait,
  root.value = NULL,
  disp,
  method = c("reml", "random.root", "fixed.root"),
  rootTip = NULL,
  do_checks = TRUE
)
}
\arguments{
\item{tree}{a phylogenetic tree of class \code{\link[ape]{phylo}}.}

\item{tipTrait}{a names vector of tip trait values, with names matching the tree labels.}

\item{root.value}{the root starting value of the process.}

\item{disp}{the dispersion value.}

\item{method}{the method used to compute the likelihood.
One of \code{reml} (the default), \code{fixed.root} or \code{random.root}.
See Details.}

\item{rootTip}{the tip used to re-root the tree, when the REML method is used.
If \code{NULL}, the tip with the smallest distance to all the others is used (see Details).
Ignored in \code{method != "reml"}.}

\item{do_checks}{if \code{FALSE}, the entry parameters are not checked for consistency.
This can be useful when doing multiple calls to the function, as in numerical optimization.
Default to \code{TRUE}.}
}
\value{
the log density value.
}
\description{
Compute the log density of the vector of trait at the tips of the phylogenetic tree, 
assuming a Cauchy process.
}
\details{
The parameters of the Cauchy Process (CP)
are \code{disp}, the dispersion of the process,
and \code{root.value}, the starting value of the process at the root (for \code{method="fixed.root"}).

The model assumes that each increment of the trait \eqn{X} on a branch going from node \eqn{k} to \eqn{l} 
follows a Cauchy distribution, with a dispersion proportional to the length \eqn{t_l} of the branch:
\deqn{X_l - X_k \sim \mathcal{C}(0, \mbox{disp} \times t_l).}

The \code{method} argument specifies the type of likelihood that is computed:
\describe{
  \item{\code{method="reml"}:}{ 
  the dispersion parameter is fitted using the REML criterion,
  obtained by re-rooting the tree to one of the tips.
  The default tip used to reroot the tree is:
  \code{rootTip = which.min(colSums(cophenetic.phylo(tree)))}.
  Any tip can be used, but this default empirically proved to be the most robust numerically;
  }
  \item{\code{method="random.root"}:}{ 
  the root value is assumed to be a random Cauchy variable, centered at \code{root.value=0},
  and with a dispersion \code{disp_root = disp * root.edge};
  }
  \item{\code{method="fixed.root"}:}{ 
  the model is fitted conditionally on the root value \code{root.value},
  i.e. with a model where the root value is fixed and inferred from the data.
  }
}
}
\examples{
phy <- ape::rphylo(5, 0.1, 0)
dat <- rTraitCauchy(n = 1, phy = phy, model = "cauchy", parameters = list(root.value = 0, disp = 1))
logDensityTipsCauchy(phy, dat, 0, 1, method = "fixed.root")

}
\seealso{
\code{\link{fitCauchy}}
}
