% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/factor_functions.R
\name{factor.analysis}
\alias{factor.analysis}
\title{Factor analysis}
\usage{
factor.analysis(Y, r, method = c("ml", "pc", "esa"))
}
\arguments{
\item{Y}{data matrix, a n*p matrix}

\item{r}{number of factors}

\item{method}{algorithm to be used}
}
\value{
a list of objects
\describe{
\item{Gamma}{estimated factor loadings}
\item{Z}{estimated latent factors}
\item{Sigma}{estimated noise variance matrix}
}
}
\description{
The main function for factor analysis with potentially high dimensional variables.
Here we implement some recent algorithms that is optimized for the high dimensional problem where
the number of samples n is less than the number of variables p.
}
\details{
The three methods are quasi-maximum likelihood (ml),
principal component analysis (pc),
and factor analysis using an early stopping criterion (esa).

The ml is iteratively solved the Expectation-Maximization algorithm
using the PCA solution as the initial value.
See Bai and Li (2012) and for more details. For the esa method, see
Owen and Wang (2015) for more details.
}
\examples{
## a factor model
n <- 100
p <- 1000
r <- 5
Z <- matrix(rnorm(n * r), n, r)
Gamma <- matrix(rnorm(p * r), p, r)
Y <- Z \%*\% t(Gamma) + rnorm(n * p)

## to check the results, verify the true factors are in the linear span of the estimated factors.
pc.results <- factor.analysis(Y, r = 5, "pc")
sapply(summary(lm(Z ~ pc.results$Z)), function(x) x$r.squared)

ml.results <- factor.analysis(Y, r = 5, "ml")
sapply(summary(lm(Z ~ ml.results$Z)), function(x) x$r.squared)

esa.results <- factor.analysis(Y, r = 5, "esa")
sapply(summary(lm(Z ~ esa.results$Z)), function(x) x$r.squared)

}
\references{
{
Bai, J. and Li, K. (2012). Statistical analysis of factor models of high dimension. \emph{The Annals of Statistics 40}, 436-465.
Owen, A. B. and Wang, J. (2015). Bi-cross-validation for factor analysis. \emph{arXiv:1503.03515}.
}
}
\seealso{
\code{\link{fa.pc}}, \code{\link{fa.em}}, \code{\link[esaBcv]{ESA}}
}
