% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run.R
\name{run}
\alias{run}
\title{Run Cargo}
\usage{
run(
  ...,
  minimum_version = ".",
  methods = c("envir", "path", "cache"),
  environment_variables = list(),
  rustflags = NULL,
  use_packageStartupMessage = FALSE,
  must_be_silent = FALSE
)
}
\arguments{
\item{...}{Character vector of command line arguments passed to the
\code{cargo} command.}

\item{minimum_version}{A character string representing the minimum version of
Rust that is needed. Or a path to the root of a package (i.e., the
directory containing the DESCRIPTION file), in which case the value is
found from the field: \code{SystemRequirements: Cargo (>= XXXX)}.}

\item{methods}{A character vector potentially containing values
\code{"envir"}, \code{"path"}, and \code{"cache"}. This indicates the
methods to use (and their order) when searching for a suitable Cargo
installation. \code{"envir"} indicates to try to use the values of the
\code{CARGO_HOME} and \code{RUSTUP_HOME} environment variables.
\code{"path"} indicates to try to use the directories \code{.cargo} and
\code{.rustup} in the user's home directory. \code{"cache"} indicates to
try to use the directories from the cargo package's own installation as
given by the \code{tools::R_user_dir('cargo', 'cache')}.}

\item{environment_variables}{A named character vector providing environment
variables which should be temporarily set while running Cargo.  Note that
\code{RUSTUP_HOME} and \code{CARGO_HOME} are automatically set by this
function.}

\item{rustflags}{A character vector from which the
\code{CARGO_ENCODED_RUSTFLAGS} environment variables is constructed and
then temporarily set. Or, if \code{NULL}, this environment variable is left
unchanged.}

\item{use_packageStartupMessage}{Should essential messages be displayed using
\code{\link[base:message]{base::packageStartupMessage()}}?}

\item{must_be_silent}{Should all messages be suppressed (regardless of the
value of \code{use_packageStartupMessage})?}
}
\value{
A logical equaling \code{TRUE} if and only if the minimum version is
available and the exit status of the command is zero (indicating success).
The function is designed to never throw a warning or error.
}
\description{
This function runs Cargo (Rust's package manager) with the \code{...}
arguments passed as command line arguments.
}
\examples{
if ( run("--version", must_be_silent=TRUE) != 0 ) {
    cat("Cargo is not installed. Please run cargo::install() in an interactive session.")
}

}
