% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cross_compile.R
\name{cross_compile}
\alias{cross_compile}
\title{Cross Compile Static Library for CRAN}
\usage{
cross_compile(
  destination_directory,
  pkgroot = ".",
  target = "CRAN",
  minimum_version = file.path(pkgroot, "DESCRIPTION"),
  verbose = TRUE
)
}
\arguments{
\item{destination_directory}{An existing directory where the static libraries
should be added.}

\item{pkgroot}{The root directory of the package.}

\item{target}{A character vector giving Rust targets (e.g.
\code{"x86_64-pc-windows-gnu"}). The value \code{"CRAN"} is replaced by all
targets for CRAN build machines.}

\item{minimum_version}{A character string representing the minimum version of
Rust that is needed. Or a path to the DESCRIPTION file, in which case the
value is found from the field: \code{SystemRequirements: Cargo (>= XXXX)}.}

\item{verbose}{Should Cargo be run in non-quiet mode?}
}
\value{
\code{NULL}, invisibly.
}
\description{
This function cross compiles the Rust static library for CRAN's target
platforms. The package developer can then uploaded these to a web server.
Then, if a particular CRAN build machine does not have a sufficient
installation of the Rust toolchain, the package's \file{tools/staticlib.R}
script can download the appropriate static library.
}
\seealso{
target
}
