% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/caretStack.R
\name{caretStack}
\alias{caretStack}
\title{Combine several predictive models via stacking}
\usage{
caretStack(
  all.models,
  new_X = NULL,
  new_y = NULL,
  metric = NULL,
  trControl = NULL,
  excluded_class_id = 1L,
  ...
)
}
\arguments{
\item{all.models}{a caretList, or an object coercible to a caretList (such as a list of train objects)}

\item{new_X}{Data to predict on for the caretList, prior to training the stack (for transfer learning).
if NULL, the stacked predictions will be extracted from the caretList models.}

\item{new_y}{The outcome variable to predict on for the caretList, prior to training the stack
(for transfer learning).
If NULL, will use the observed levels from the first model in the caret stack
If 0, will include all levels.}

\item{metric}{the metric to use for grid search on the stacking model.}

\item{trControl}{a trainControl object to use for training the ensemble model. If NULL, will use defaultControl.}

\item{excluded_class_id}{The integer level to exclude from binary classification or multiclass problems.}

\item{...}{additional arguments to pass to the stacking model}
}
\value{
S3 caretStack object
}
\description{
Stack several \code{\link[caret]{train}} models using a \code{\link[caret]{train}} model.
}
\details{
Uses either transfer learning or stacking to stack models. Assumes that all models were trained on
the same number of rows of data, with the same target values. The features, cross-validation strategies,
and model types (class vs reg) may vary however. If your stack of models were trained with different number of
rows, please provide new_X and new_y so the models can predict on a common set of data for stacking.

If your models were trained on different columns, you should use stacking.

If you have both differing rows and columns in your model set, you are out of luck. You need at least
a common set of rows during training (for stacking) or a common set of columns at
inference time for transfer learning.
}
\examples{
models <- caretList(
  x = iris[1:50, 1:2],
  y = iris[1:50, 3],
  methodList = c("rpart", "glm")
)
caretStack(models, method = "glm")
}
\references{
Caruana, R., Niculescu-Mizil, A., Crew, G., & Ksikes, A. (2004).
  Ensemble Selection from Libraries of Models.
  \url{https://www.cs.cornell.edu/~caruana/ctp/ct.papers/caruana.icml04.icdm06long.pdf}
}
