% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/caretList.R
\name{caretList}
\alias{caretList}
\title{Create a list of several train models from the caret package}
\usage{
caretList(
  ...,
  trControl = NULL,
  methodList = NULL,
  tuneList = NULL,
  metric = NULL,
  continue_on_fail = FALSE,
  trim = TRUE
)
}
\arguments{
\item{...}{arguments to pass to \code{\link[caret]{train}}. Don't use the formula interface, its slower
and buggier compared to the X, y interface. Use a \code{\link[data.table]{data.table}} for X.
Particularly if you have a large dataset and/or many models, using a data.table will
avoid unnecessary copies of your data and can save a lot of time and RAM.
These arguments will determine which train method gets dispatched.}

\item{trControl}{a \code{\link[caret]{trainControl}} object. If NULL, will use defaultControl.}

\item{methodList}{optional, a character vector of caret models to ensemble.
One of methodList or tuneList must be specified.}

\item{tuneList}{optional, a NAMED list of caretModelSpec objects.
This much more flexible than methodList and allows the
specification of model-specific parameters (e.g. passing trace=FALSE to nnet)}

\item{metric}{a string, the metric to optimize for. If NULL, we will choose a good one.}

\item{continue_on_fail}{logical, should a valid caretList be returned that
excludes models that fail, default is FALSE}

\item{trim}{logical should the train models be trimmed to save memory and speed up stacking}
}
\value{
A list of \code{\link[caret]{train}} objects. If the model fails to build,
it is dropped from the list.
}
\description{
Build a list of train objects suitable for ensembling using the \code{\link{caretStack}}
function.
}
\examples{
caretList(
  Sepal.Length ~ Sepal.Width,
  head(iris, 50),
  methodList = c("glm", "lm"),
  tuneList = list(
    nnet = caretModelSpec(method = "nnet", trace = FALSE, tuneLength = 1)
  )
)
}
