% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/caretPredict.R
\name{c.train}
\alias{c.train}
\title{S3 definition for concatenating train objects}
\usage{
\method{c}{train}(...)
}
\arguments{
\item{...}{the objects of class train to bind into a caretList}
}
\value{
a \code{\link{caretList}} object
}
\description{
take N objects of class train and concatenate into an object of class caretList for future ensembling
}
\examples{
data(iris)
model_lm <- caret::train(Sepal.Length ~ .,
  data = iris,
  method = "lm"
)

model_rf <- caret::train(Sepal.Length ~ .,
  data = iris,
  method = "rf",
  tuneLength = 1L
)

model_list <- c(model_lm, model_rf)
}
