% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/caretEnsemble.R
\name{getMetric}
\alias{getAUC}
\alias{getMetric}
\alias{getMetric.train}
\alias{getRMSE}
\title{Extract a model accuracy metric from an S3 object.}
\usage{
getMetric(x, metric)

\method{getMetric}{train}(x, metric = c("AUC", "RMSE"))

getAUC(x)

getRMSE(x)
}
\arguments{
\item{x}{an object with model performanc metrics}

\item{metric}{a character, either "RMSE" or "AUC" indicating which metric to extract}
}
\value{
A numeric representing the metric desired metric.

A numeric for the AUC of the best model

A numeric for the RMSE of the best model
}
\description{
Extract a model accuracy metric from an S3 object.

Extract a model accuracy metric from a \code{\link{train}} object.

Extract the AUC metric from a \code{\link{train}} object.

Extract the RMSE metric from a model object.
}
\note{
AUC extracted from a train object is for all resamples pooled, not the average
of the AUC for each resample.

RMSE extracted from a train object is for all resamples pooled, not the average
of the RMSE for each resample. All missing values are ignored.
}

