% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FreqTab.R
\name{FreqTab}
\alias{FreqTab}
\title{Frequency table of categorical variables}
\usage{
FreqTab(data = NULL, variables = NULL, rnd = 3, decreasing = TRUE,
  use.na = FALSE)
}
\arguments{
\item{data}{\code{\link{data.frame}} with categorical variables.}

\item{variables}{name or position of categorical variables. If more than one variable is provided, contingency frequencies are calculated.}

\item{rnd}{the number of decimal places (round) or significant digits (signif) to be used.}

\item{decreasing}{\code{\link{logical}}. If \code{TRUE}, frequencies will be sorted in decreasing order, if \code{FALSE}, they will be sorted in increasing order.}

\item{use.na}{\code{\link{logical}}. If \code{FALSE} (default), missing values are omitted.}
}
\value{
\code{\link{data.frame}}.
}
\description{
Calculates and sort the count and relative frequency of categories.
}
\examples{
data(cluster_sample)
FreqTab(cluster_sample$number_of_dogs)

data(dogs)
FreqTab(dogs, c("species", "sex"))

}
\references{
Baquero, O. S., Marconcin, S., Rocha, A., & Garcia, R. D. C. M. (2018). Companion animal demography and population management in Pinhais, Brazil. Preventive Veterinary Medicine.
\url{http://oswaldosantos.github.io/capm}
}
\seealso{
\link[base]{table} and \link[base]{sort}.
}
