% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SolveIASA.R
\name{SolveIASA}
\alias{SolveIASA}
\title{Modelling of immigration, abandonment, sterilization and adoption of companion animals}
\usage{
SolveIASA(pars = NULL, init = NULL, time = NULL, alpha.owned = NULL,
  s.range = NULL, a.range = NULL, alpha.range = NULL, v.range = NULL,
  s.fm = TRUE, ...)
}
\arguments{
\item{pars}{a named \code{\link{vector}} of length 21, with point estimates of model parameters (see details).}

\item{init}{a named \code{\link{vector}} of length 8, with point estimates of model parameters (see details).}

\item{time}{time sequence for which output is wanted; the first value of times must be the initial time.}

\item{alpha.owned}{\code{\link{logical}}. If \code{TRUE}, adoption rate is relative to the owned population (proportion of the owned population). If \code{FALSE}, it is relative to the unowned population.}

\item{s.range}{optional sequence (between 0 and 1) of the sterilization rates to be simulated.}

\item{a.range}{optional \code{\link{vector}} of length 2, with range (ie, confidence interval) of abandonment rates to be assessed. If given, the rates evaluated are those specified by the argument plus the point estimate given in \code{pars}.}

\item{alpha.range}{optional \code{\link{vector}} of length 2, with range (ie, confidence interval) of adoption rates to be assessed. If given, the rates evaluated are those specified by the argument plus the point estimate given in \code{pars}.}

\item{v.range}{optional \code{\link{vector}} of length 2, with range of values of immigration rates to be assessed.}

\item{s.fm}{logical. If \code{TRUE}, s.range is used for females and males and if \code{FALSE}, it is used for only females (for males, the point estimate given in \code{pars} is used.)}

\item{...}{further arguments passed to \link[deSolve]{ode} function.}
}
\value{
\code{\link{list}}. The first element, \code{name}, is a string with the name of the function, the second element, \code{model}, is the model function. The third, fourth and fifth elements are vectors (\code{pars}, \code{init}, \code{time}, respectively) containing the \code{pars}, \code{init} and \code{time} arguments of the function. The sixth element \code{results} is a \code{\link{data.frame}} with up to as many rows as elements in time. The first column contain the time and subsequent columns contain the size of specific subpopulations, named according to conventions above. The \code{group} column differentiate between owned and unowned. When *.range arguments are given, the last fourth columsn specify their instances.
}
\description{
System of ordinary differential equations to simulate the effect of immigration of owned dogs, abandonment, sterilization of owned and unowned dogs and adoption, on population dynamics.
}
\details{
The implemented model is described by Baquero, et. al., 2016 and the function is a wrapper around the defaults of \link[deSolve]{ode} function, whose help page must be consulted for details.

The \code{pars} argument must contain named values, using the following conventions: \code{1}: owned animals; \code{2}: unowned animals; \code{f}: females; \code{m}: males. Then:

 
\code{b1} and \code{b2}: number of births.

\code{df1}, \code{dm1}, \code{df2} and \code{dm2}: death rate.

\code{sf1}, \code{sm1}, \code{sf2} and \code{sm2}: sterilization rate.

\code{k1} and \code{k2}: carrying capacity.

\code{h1} and \code{h2}: mean harem size.

\code{a}: abandonment rate.

\code{alpha}: adoption rate.

\code{v}: immigration rate.

\code{z}: proportion of sterilized immigrants.

The \code{init} argument must contain named values for the inital number of animals, using the following conventions: \code{1}: owned animals; \code{2}: unowned animals; \code{f}: females; \code{m}: males; and \code{s}: sterilized. Then, the names are:

\code{f1}, \code{fs1}, \code{m1}, \code{ms1}, \code{f2}, \code{fs2}, \code{m2} and \code{ms2}.

If any range is specified (e.g \code{s.range}), the remaining ranges must be specified too (\code{a.range}, \code{alpha.range} and \code{v.range}).
The function is a wrapper around the defaults of \link[deSolve]{ode} function, whose help page must be consulted for details. An exception is the method argument, which here has "rk4" as a default.
}
\note{
Logistic growth models are not intended for scenarios in which
population size is greater than carrying capacity and growth rate is negative.
}
\examples{
## Parameters and intial conditions.
data(dogs)
dogs_iasa <- GetDataIASA(dogs,
                         destination.label = "Pinhais",
                         total.estimate = 50444)

# Solve for point estimates.
solve_iasa_pt <- SolveIASA(pars = dogs_iasa$pars,
                           init = dogs_iasa$init,
                           time = 0:15,
                           alpha.owned = TRUE,
                           method = 'rk4')
solve_iasa_rg <- SolveIASA(pars = dogs_iasa$pars,
                           init = dogs_iasa$init, 
                           time = 0:10,
                           alpha.owned = TRUE,
                           s.range = seq(0, .4, l = 15), 
                           a.range = c(0, .2), 
                           alpha.range = c(0, .05),
                           v.range = c(0, .1),
                           method = 'rk4')

}
\references{
Baquero, O. S., Akamine, L. A., Amaku, M., & Ferreira, F. (2016). Defining priorities for dog population management through mathematical modeling. Preventive veterinary medicine, 123, 121-127.

\url{http://oswaldosantos.github.io/capm}
}
\seealso{
\link[deSolve]{ode}.
}
