% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotLocalSens.R
\name{PlotLocalSens}
\alias{PlotLocalSens}
\title{Plot results of CalculateLocalSens function}
\usage{
PlotLocalSens(local.out = NULL, x.sens = "Time", y.sens = "Sensitivity",
  y.ind = c("L1", "L2", "Mean", "Min", "Max"), bar.colors = "DarkRed",
  label.size = 10, x.axis.angle = 90, type = 1)
}
\arguments{
\item{local.out}{output from \code{\link{CalculateLocalSens}} function.}

\item{x.sens}{string with the name for the x axis.}

\item{y.sens}{string with the name for the y axis of the sensitivity functions (when \code{type = 6}).}

\item{y.ind}{string with the name for the y axis of the parameter importance indices.}

\item{bar.colors}{any valid specification of a color.}

\item{label.size}{a number to specify the size of axes labels and text.}

\item{x.axis.angle}{a number with angle of rotation for x axis text. Passed to \code{angle} argument of \code{\link{element_text}}.}

\item{type}{a number to define the type of graphical output. \code{1}: importance index L1; \code{2}:  importance index L2; \code{3}: mean of sensitivity functions; \code{5}: minimum of sensitivity functions; and \code{5}: maximum of sensitivity functions; \code{6}: sensitivity functions and all importance indices are ploted.}
}
\description{
Plot results of the \code{\link{CalculateLocalSens}} function.
}
\details{
Font size of saved plots is usually different to the font size seen in graphic browsers. Before changing font sizes, see the final result in saved (or preview) plots.
}
\examples{
## IASA model#' 
## Parameters and intial conditions.
data(dogs)
dogs_iasa <- GetDataIASA(dogs,
                        destination.label = "Pinhais",
                        total.estimate = 50444)#' 
# Solve for point estimates.
solve_iasa_pt <- SolveIASA(pars = dogs_iasa$pars,
                         init = dogs_iasa$init,
                         time = 0:15,
                         alpha.owned = TRUE,
                         method = 'rk4')#' 
## Calculate local sensitivities to all parameters.
local_solve_iasa2 <- CalculateLocalSens(
 model.out = solve_iasa_pt, sensv = "n2")#' 
## Plot local sensitivities
PlotLocalSens(local_solve_iasa2)#' 

}
\references{
Chang W (2012). R Graphics Cookbook. O'Reilly Media, Inc.

Soetaert K, Cash J and Mazzia F (2012). Solving differential equations in R. Springer.

Baquero, O. S., Marconcin, S., Rocha, A., & Garcia, R. D. C. M. (2018). Companion animal demography and population management in Pinhais, Brazil. Preventive Veterinary Medicine.

\url{http://oswaldosantos.github.io/capm}
}
\seealso{
\link[FME]{plot.sensFun}.
}
