% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load.selection.table.R
\name{load.selection.table}
\alias{load.selection.table}
\title{load.selection.table}
\usage{
load.selection.table(path_selection_table)
}
\arguments{
\item{path_selection_table}{the path to the file containing the selection
table.}
}
\value{
Returns data frame with all selections.
}
\description{
Loads single Raven selection table into a dataframe.
}
\examples{
require(callsync)
require(seewave)
require(tuneR)
path_git = 'https://raw.githubusercontent.com'
path_repo = '/simeonqs/callsync/master/tests/testthat/files'
file_1 = '/2020_10_27_091634.Table.1.selections.txt'
file_2 = '/2020_10_27_132148.Table.1.selections.txt'
url_1 = paste0(path_git, path_repo, file_1)
url_2 = paste0(path_git, path_repo, file_2)
local_file_1 = paste(tempdir(), file_1, sep = '/')
local_file_2 = paste(tempdir(), file_2, sep = '/')
if(!file.exists(local_file_1))
  download.file(url_1, destfile = local_file_1, mode = 'wb',)
if(!file.exists(local_file_2))
  download.file(url_2, destfile = local_file_2, mode = 'wb')
st = load.selection.tables(path_selection_tables = tempdir())

}
