% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eval-bg.R
\name{r_bg}
\alias{r_bg}
\title{Evaluate an expression in another R session, in the background}
\usage{
r_bg(func, args = list(), libpath = .libPaths(),
  repos = c(getOption("repos"), c(CRAN = "https://cloud.r-project.org")),
  stdout = "|", stderr = "|", error = getOption("callr.error",
  "error"), cmdargs = c("--slave", "--no-save", "--no-restore"),
  system_profile = FALSE, user_profile = FALSE,
  env = rcmd_safe_env(), supervise = FALSE)
}
\arguments{
\item{func}{Function object to call in the new R process.
The function should be self-contained and only refer to
other functions and use variables explicitly from other packages
using the \code{::} notation. The environment of the function
is set to \code{.GlobalEnv} before passing it to the child process.
Because of this, it is good practice to create an anonymous
function and pass that to \code{callr}, instead of passing
a function object from a (base or other) package. In particular\preformatted{r(.libPaths)
}

does not work, because \code{.libPaths} is defined in a special
environment, but\preformatted{r(function() .libPaths())
}

works just fine.}

\item{args}{Arguments to pass to the function. Must be a list.}

\item{libpath}{The library path.}

\item{repos}{The \emph{repos} option. If \code{NULL}, then no
\emph{repos} option is set. This options is only used if
\code{user_profile} or \code{system_profile} is set \code{FALSE},
as it is set using the system or the user profile.}

\item{stdout}{The name of the file the standard output of
the child R process will be written to.
If the child process runs with the \code{--slave} option (the default),
then the commands are not echoed and will not be shown
in the standard output. Also note that you need to call \code{print()}
explicitly to show the output of the command(s).}

\item{stderr}{The name of the file the standard error of
the child R process will be written to.
In particular \code{message()} sends output to the standard
error. If nothing was sent to the standard error, then this file
will be empty. This can be the same file as \code{stderr}, although there
is no guarantee that the lines will be in the correct chronological
order.}

\item{error}{What to do if the remote process throws an error.
See details below.}

\item{cmdargs}{Command line arguments to pass to the R process.
Note that \code{c("-f", rscript)} is appended to this, \code{rscript}
is the name of the script file to run. This contains a call to the
supplied function and some error handling code.}

\item{system_profile}{Whether to use the system profile file.}

\item{user_profile}{Whether to use the user's profile file.}

\item{env}{Environment variables to set for the child process.}

\item{supervise}{Whether to register the process with a supervisor. If \code{TRUE},
the supervisor will ensure that the process is killed when the R process
exits.}
}
\value{
An \code{r_process} object, which inherits from \link{process},
so all \code{process} methods can be called on it, and in addition it also
has a \code{get_result()} method to collect the result.
}
\description{
Starts evaluating an R function call in a background R process, and
returns immediately.
}
\examples{
\dontrun{
rx <- r_bg(function() 1 + 2)

# wait until it is done
rx$wait()
rx$is_alive()
rx$get_result()
}
}
