% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transition_matrix_plot.R
\name{transition_matrix_plot}
\alias{transition_matrix_plot}
\title{Transition Matrix Plot}
\usage{
transition_matrix_plot(object = NULL, n_stages = NULL)
}
\arguments{
\item{object}{Either an S4 object of class `"MST"` or class `"MAT"`, or a matrix describing how individuals can transition from one stage to the next. If an S4 object is provided, the `transition.matrix` slot is used to create the plot.}

\item{n_stages}{A numeric value indicating how many stages are used in the (mixed) multistage test. If an S4 object is provided, this value is taken from the object and the input value is ignored.}
}
\value{
A plot using the current graphic device.
}
\description{
Given a transition matrix and the number of modules at each stage, produces a plot
that demonstrates the potential paths through a (mixed) multistage test.
}
\examples{
# Create a plot for a multistage test with a 1-3-3 design
data('example_transition_matrix')
transition_matrix_plot(example_transition_matrix, n_stages =  3)

\dontrun{
# Save the plot as a png file.
png("Example 1-3-3 Transition Matrix Plot.png")
transition_matrix_plot(example_transition_matrix, n_stages = 3)
title("Transition Matrix for a 1-3-3 Design MST")
dev.off()

# Use the `results` object from the `mixed_adaptive_test()` example to create
# a transition matrix plot and save as a .pdf file.
pdf("MAT Transition Matrix.pdf")
transition_matrix_plot(results)
title("Transition Matrix from the mixed_adaptive_test Example")
dev.off()
}

}
