% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.plots.R
\name{cor_plot}
\alias{cor_plot}
\title{Plot method for \link{cmicroRNA} and \link{cTF} objects}
\usage{
cor_plot(ob, study, ...)
}
\arguments{
\item{ob}{A \link{cmicroRNA} or \link{cTF} object such as this returned by
calling \link{cmicroRNA} or \link{cTF}.}

\item{study}{A \code{character} vector of The Cancer Genome Atlas (TCGA)
study identifiers. To view the available studies in TCGA project,
\url{https://tcga-data.nci.nih.gov/docs/publications/tcga}. When left to
default \code{NULL} all available studies will be included.}

\item{...}{Other options}
}
\value{
A \code{ggplot} object of a dot plot of the correlation values 
between genes and microRNAs or transcription factors in a TCGA study.
}
\description{
A dot plot of microRNA/TF correlation in a single study of TCGA. When the
object \link{cmicroRNA}/\link{cTF} contains more than one TCGA studies, the
argument \code{study} is a requirement.
}
\examples{
# locate the testset file and connect
fl <- system.file('extdata', 'cRegulome.db', package = 'cRegulome')
conn <- RSQLite::dbConnect(RSQLite::SQLite(), fl)

# enter a custom query with different arguments
dat <- get_mir(conn,
               mir = 'hsa-let-7g',
               study = 'STES',
               min_abs_cor = .3,
               max_num = 5)

# make a cmicroRNA object   
cmir <- cmicroRNA(dat)

# print object
cor_plot(cmir)

}
