% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{cor_tidy}
\alias{cor_tidy}
\title{Tidy \link{cmicroRNA} and \link{cTF} objects}
\usage{
cor_tidy(ob)
}
\arguments{
\item{ob}{A \link{cmicroRNA} or \link{cTF} object such as this returned by
calling \link{cmicroRNA} or \link{cTF}.}
}
\value{
A tidy \code{data.frame} of four columns. \code{mirna_base} or
\code{tf}is the microRNA miRBase IDs, \code{feature} is the features/genes,
\code{cor} is the corresponding expression correlations and \code{study}
is TCGA study ID.
}
\description{
Tidy \link{cmicroRNA} and \link{cTF} objects
}
\examples{
# load required libraries
library(RSQLite)
library(cRegulome)

# locate the testset file and connect
fl <- system.file('extdata', 'cRegulome.db', package = 'cRegulome')
conn <- dbConnect(SQLite(), fl)

# enter a custom query with different arguments
dat <- get_mir(conn,
               mir = 'hsa-let-7g',
               study = 'STES',
               min_abs_cor = .3,
               max_num = 5)

# make a cmicroRNA object   
cmir <- cmicroRNA(dat)

# convert cmicroRNA object to a tidy data.frame
tidy_cmir <- cor_tidy(cmir)

}
