% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary.SDDRautoregression}
\alias{summary.SDDRautoregression}
\title{Provides summary of verifying hypotheses about autoregressive parameters}
\usage{
\method{summary}{SDDRautoregression}(object, ...)
}
\arguments{
\item{object}{an object of class \code{SDDRautoregression} obtained using the
\code{verify_autoregression()} function.}

\item{...}{additional arguments affecting the summary produced.}
}
\value{
A table reporting the logarithm of Bayes factors of the restriction
against no restriction posterior odds in \code{"log(SDDR)"}, 
its numerical standard error \code{"NSE"}, and the implied posterior 
probability of the restriction holding or not hypothesis, 
\code{"Pr[H0|data]"} and \code{"Pr[H1|data]"} 
respectively.
}
\description{
Provides summary of the Savage-Dickey density ratios
for verification of hypotheses about autoregressive parameters.
}
\examples{
# upload data
data(us_fiscal_lsuw)

# specify the model and set seed
specification  = specify_bsvar_sv$new(us_fiscal_lsuw, p = 1)
set.seed(123)

# estimate the model
posterior      = estimate(specification, 10, thin = 1)

# verify autoregression
H0             = matrix(NA, ncol(us_fiscal_lsuw), ncol(us_fiscal_lsuw) + 1)
H0[1,3]        = 0        # a hypothesis of no Granger causality from gdp to ttr
sddr           = verify_autoregression(posterior, H0)
summary(sddr)

# workflow with the pipe |>
############################################################
set.seed(123)
us_fiscal_lsuw |>
  specify_bsvar_sv$new(p = 1) |>
  estimate(S = 10, thin = 1) |> 
  verify_autoregression(hypothesis = H0) |> 
  summary() -> sddr_summary

}
\seealso{
\code{\link{verify_autoregression}}
}
\author{
Tomasz Woźniak \email{wozniak.tom@pm.me}
}
