% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary.PosteriorSigma}
\alias{summary.PosteriorSigma}
\title{Provides posterior summary of structural shocks' conditional standard 
deviations}
\usage{
\method{summary}{PosteriorSigma}(object, ...)
}
\arguments{
\item{object}{an object of class PosteriorSigma obtained using the
\code{compute_conditional_sd()} function containing posterior draws of 
conditional standard deviations of structural shocks.}

\item{...}{additional arguments affecting the summary produced.}
}
\value{
A list reporting the posterior mean, standard deviations, as well as 
5 and 95 percentiles of the structural shocks' conditional standard deviations
for each of the shocks and periods.
}
\description{
Provides posterior summary of structural shocks' conditional 
standard deviations including their mean, standard deviations, as well as 
5 and 95 percentiles.
}
\examples{
# upload data
data(us_fiscal_lsuw)

# specify the model and set seed
set.seed(123)
specification  = specify_bsvar_sv$new(us_fiscal_lsuw)

# run the burn-in
burn_in        = estimate(specification, 5)

# estimate the model
posterior      = estimate(burn_in, 5)

# compute structural shocks' conditional standard deviations
sigma          = compute_conditional_sd(posterior)
sigma_summary  = summary(sigma)

# workflow with the pipe |>
############################################################
set.seed(123)
us_fiscal_lsuw |>
  specify_bsvar_sv$new() |>
  estimate(S = 5) |> 
  estimate(S = 5) |> 
  compute_conditional_sd() |>
  summary() -> sigma_summary

}
\seealso{
\code{\link{compute_conditional_sd}}
}
\author{
Tomasz Woźniak \email{wozniak.tom@pm.me}
}
