% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/specify_bsvar_msh.R
\name{specify_posterior_bsvar_msh}
\alias{specify_posterior_bsvar_msh}
\title{R6 Class Representing PosteriorBSVAR-MSH}
\description{
The class PosteriorBSVAR-MSH contains posterior output and the specification including 
the last MCMC draw for the bsvar model with Markov Switching Heteroskedasticity. 
Note that due to the thinning of the MCMC output the starting value in element \code{last_draw}
might not be equal to the last draw provided in element \code{posterior}.
}
\examples{
# This is a function that is used within estimate_bsvar()
data(us_fiscal_lsuw)
specification  = specify_bsvar_msh$new(us_fiscal_lsuw, p = 4, M = 2)
set.seed(123)
estimate       = estimate_bsvar_msh(10, specification, thin = 1)
class(estimate)


## ------------------------------------------------
## Method `specify_posterior_bsvar_msh$get_posterior`
## ------------------------------------------------

data(us_fiscal_lsuw)
specification  = specify_bsvar_msh$new(us_fiscal_lsuw, M = 2)
set.seed(123)
estimate       = estimate_bsvar_msh(10, specification, thin = 1)
estimate$get_posterior()


## ------------------------------------------------
## Method `specify_posterior_bsvar_msh$get_last_draw`
## ------------------------------------------------

data(us_fiscal_lsuw)

# specify the model and set seed
specification  = specify_bsvar_msh$new(us_fiscal_lsuw, p = 4, M = 2)

# run the burn-in
set.seed(123)
burn_in        = estimate_bsvar_msh(10, specification, thin = 2)

# get the last draw
last_draw      = burn_in$get_last_draw()

# estimate the model
posterior      = estimate_bsvar_msh(10, last_draw, thin = 2)


## ------------------------------------------------
## Method `specify_posterior_bsvar_msh$is_normalised`
## ------------------------------------------------

# upload data
data(us_fiscal_lsuw)

# specify the model and set seed
specification  = specify_bsvar_msh$new(us_fiscal_lsuw, p = 4, M = 2)

# estimate the model
set.seed(123)
posterior      = estimate_bsvar_msh(10, specification, thin = 1)

# check normalisation status beforehand
posterior$is_normalised()

# normalise the posterior
BB            = posterior$last_draw$starting_values$B      # get the last draw of B
B_hat         = diag(sign(diag(BB))) \%*\% BB                # set positive diagonal elements
bsvars::normalise_posterior(posterior, B_hat)              # draws in posterior are normalised

# check normalisation status afterwards
posterior$is_normalised()


## ------------------------------------------------
## Method `specify_posterior_bsvar_msh$set_normalised`
## ------------------------------------------------

# This is an internal function that is run while executing normalise_posterior()
# Observe its working by analysing the workflow:

# upload data
data(us_fiscal_lsuw)

# specify the model and set seed
specification  = specify_bsvar$new(us_fiscal_lsuw, p = 4)
set.seed(123)

# estimate the model
posterior      = estimate_bsvar(10, specification, thin = 1)

# check normalisation status beforehand
posterior$is_normalised()

# normalise the posterior
BB            = posterior$last_draw$starting_values$B      # get the last draw of B
B_hat         = diag(sign(diag(BB))) \%*\% BB                # set positive diagonal elements
bsvars::normalise_posterior(posterior, B_hat)              # draws in posterior are normalised

# check normalisation status afterwards
posterior$is_normalised()

}
\seealso{
\code{\link{estimate_bsvar_msh}}, \code{\link{specify_bsvar_msh}}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{last_draw}}{an object of class BSVAR-MSH with the last draw of the current MCMC run as the starting value to be passed to the continuation of the MCMC estimation using \code{bsvar_msh()}.}

\item{\code{posterior}}{a list containing Bayesian estimation output.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-PosteriorBSVAR-MSH-new}{\code{specify_posterior_bsvar_msh$new()}}
\item \href{#method-PosteriorBSVAR-MSH-get_posterior}{\code{specify_posterior_bsvar_msh$get_posterior()}}
\item \href{#method-PosteriorBSVAR-MSH-get_last_draw}{\code{specify_posterior_bsvar_msh$get_last_draw()}}
\item \href{#method-PosteriorBSVAR-MSH-is_normalised}{\code{specify_posterior_bsvar_msh$is_normalised()}}
\item \href{#method-PosteriorBSVAR-MSH-set_normalised}{\code{specify_posterior_bsvar_msh$set_normalised()}}
\item \href{#method-PosteriorBSVAR-MSH-clone}{\code{specify_posterior_bsvar_msh$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PosteriorBSVAR-MSH-new"></a>}}
\if{latex}{\out{\hypertarget{method-PosteriorBSVAR-MSH-new}{}}}
\subsection{Method \code{new()}}{
Create a new posterior output PosteriorBSVAR-MSH.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{specify_posterior_bsvar_msh$new(specification_bsvar, posterior_bsvar)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{specification_bsvar}}{an object of class BSVAR-MSH with the last draw of the current MCMC run as the starting value.}

\item{\code{posterior_bsvar}}{a list containing Bayesian estimation output.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A posterior output PosteriorBSVAR-MSH.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PosteriorBSVAR-MSH-get_posterior"></a>}}
\if{latex}{\out{\hypertarget{method-PosteriorBSVAR-MSH-get_posterior}{}}}
\subsection{Method \code{get_posterior()}}{
Returns a list containing Bayesian estimation output.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{specify_posterior_bsvar_msh$get_posterior()}\if{html}{\out{</div>}}
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{data(us_fiscal_lsuw)
specification  = specify_bsvar_msh$new(us_fiscal_lsuw, M = 2)
set.seed(123)
estimate       = estimate_bsvar_msh(10, specification, thin = 1)
estimate$get_posterior()

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PosteriorBSVAR-MSH-get_last_draw"></a>}}
\if{latex}{\out{\hypertarget{method-PosteriorBSVAR-MSH-get_last_draw}{}}}
\subsection{Method \code{get_last_draw()}}{
Returns an object of class BSVAR-MSH with the last draw of the current MCMC run as the starting value to be passed to the continuation of the MCMC estimation using \code{bsvar_msh()}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{specify_posterior_bsvar_msh$get_last_draw()}\if{html}{\out{</div>}}
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{data(us_fiscal_lsuw)

# specify the model and set seed
specification  = specify_bsvar_msh$new(us_fiscal_lsuw, p = 4, M = 2)

# run the burn-in
set.seed(123)
burn_in        = estimate_bsvar_msh(10, specification, thin = 2)

# get the last draw
last_draw      = burn_in$get_last_draw()

# estimate the model
posterior      = estimate_bsvar_msh(10, last_draw, thin = 2)

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PosteriorBSVAR-MSH-is_normalised"></a>}}
\if{latex}{\out{\hypertarget{method-PosteriorBSVAR-MSH-is_normalised}{}}}
\subsection{Method \code{is_normalised()}}{
Returns \code{TRUE} if the posterior has been normalised using \code{normalise_posterior()} and \code{FALSE} otherwise.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{specify_posterior_bsvar_msh$is_normalised()}\if{html}{\out{</div>}}
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{# upload data
data(us_fiscal_lsuw)

# specify the model and set seed
specification  = specify_bsvar_msh$new(us_fiscal_lsuw, p = 4, M = 2)

# estimate the model
set.seed(123)
posterior      = estimate_bsvar_msh(10, specification, thin = 1)

# check normalisation status beforehand
posterior$is_normalised()

# normalise the posterior
BB            = posterior$last_draw$starting_values$B      # get the last draw of B
B_hat         = diag(sign(diag(BB))) \%*\% BB                # set positive diagonal elements
bsvars::normalise_posterior(posterior, B_hat)              # draws in posterior are normalised

# check normalisation status afterwards
posterior$is_normalised()

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PosteriorBSVAR-MSH-set_normalised"></a>}}
\if{latex}{\out{\hypertarget{method-PosteriorBSVAR-MSH-set_normalised}{}}}
\subsection{Method \code{set_normalised()}}{
Sets the private indicator \code{normalised} to TRUE.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{specify_posterior_bsvar_msh$set_normalised(value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{value}}{(optional) a logical value to be passed to indicator \code{normalised}.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{# This is an internal function that is run while executing normalise_posterior()
# Observe its working by analysing the workflow:

# upload data
data(us_fiscal_lsuw)

# specify the model and set seed
specification  = specify_bsvar$new(us_fiscal_lsuw, p = 4)
set.seed(123)

# estimate the model
posterior      = estimate_bsvar(10, specification, thin = 1)

# check normalisation status beforehand
posterior$is_normalised()

# normalise the posterior
BB            = posterior$last_draw$starting_values$B      # get the last draw of B
B_hat         = diag(sign(diag(BB))) \%*\% BB                # set positive diagonal elements
bsvars::normalise_posterior(posterior, B_hat)              # draws in posterior are normalised

# check normalisation status afterwards
posterior$is_normalised()

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PosteriorBSVAR-MSH-clone"></a>}}
\if{latex}{\out{\hypertarget{method-PosteriorBSVAR-MSH-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{specify_posterior_bsvar_msh$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
