% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear_reg-predict.R
\name{predict.brulee_linear_reg}
\alias{predict.brulee_linear_reg}
\title{Predict from a \code{brulee_linear_reg}}
\usage{
\method{predict}{brulee_linear_reg}(object, new_data, type = NULL, epoch = NULL, ...)
}
\arguments{
\item{object}{A \code{brulee_linear_reg} object.}

\item{new_data}{A data frame or matrix of new predictors.}

\item{type}{A single character. The type of predictions to generate.
Valid options are:
\itemize{
\item \code{"numeric"} for numeric predictions.
}}

\item{epoch}{An integer for the epoch to make predictions. If this value
is larger than the maximum number that was fit, a warning is issued and the
parameters from the last epoch are used. If left \code{NULL}, the epoch
associated with the smallest loss is used.}

\item{...}{Not used, but required for extensibility.}
}
\value{
A tibble of predictions. The number of rows in the tibble is guaranteed
to be the same as the number of rows in \code{new_data}.
}
\description{
Predict from a \code{brulee_linear_reg}
}
\examples{
\donttest{
if (torch::torch_is_installed()) {

 data(ames, package = "modeldata")

 ames$Sale_Price <- log10(ames$Sale_Price)

 set.seed(1)
 in_train <- sample(1:nrow(ames), 2000)
 ames_train <- ames[ in_train,]
 ames_test  <- ames[-in_train,]

 # Using recipe
 library(recipes)

 ames_rec <-
  recipe(Sale_Price ~ Longitude + Latitude, data = ames_train) \%>\%
    step_normalize(all_numeric_predictors())

 set.seed(2)
 fit <- brulee_linear_reg(ames_rec, data = ames_train,
                           epochs = 50, batch_size = 32)

 predict(fit, ames_test)
}
}
}
